import numpy as np
import matplotlib.pyplot as plt

'''
GDEpochs = np.arange(21) * 150
GDEpochs[0] = 30
#print(GDEpochs)
SGDEpochs = np.arange(41) * 5 - 1
SGDEpochs[0] = 0
print(SGDEpochs)
GDProductTraces = []
GDFrobeniuses = []
GDHessianTraces = []
SGDProductTraces = []
SGDFrobeniuses = []
SGDHessianTraces = []

for epoch in GDEpochs:
    file = open('Saved01/GD03/Traces/epoch{}.trace'.format(epoch), 'r')
    file.readline()
    GDProductTraces.append(float(file.readline()))
    GDFrobeniuses.append(float(file.readline()))
    GDHessianTraces.append(float(file.readline()))

for i in range(21):
    GDEpochs[i] = int(GDEpochs[i] / 30)

for epoch in SGDEpochs:
    file = open('Saved01/SGD01/Traces/epoch{}.trace'.format(epoch), 'r')
    file.readline()
    SGDProductTraces.append(float(file.readline()))
    SGDFrobeniuses.append(float(file.readline()))
    SGDHessianTraces.append(float(file.readline()))

plt.plot(GDEpochs, GDProductTraces, color='b', label="GD")
plt.plot(SGDEpochs, SGDProductTraces, color='r', label="SGD")
#plt.plot(SGDEpochs, SGDProductTraces2, color='g', label="SGD2")
#plt.plot(SGDEpochs, SGDProductTraces3, color='y', label="SGD3")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
# plt.yscale('log')
plt.legend()
plt.title("Trace of Hessian and Covariance Matrix product of GD and SGD on MNIST")
plt.xlabel("Epochs")
plt.ylabel("Trace")
plt.savefig("Trace")
plt.close()

plt.plot(GDEpochs, GDFrobeniuses, color='b', label="GD")
plt.plot(SGDEpochs, SGDFrobeniuses, color='r', label="SGD")
#plt.plot(SGDEpochs, SGDFrobeniuses2, color='g', label="SGD2")
#plt.plot(SGDEpochs, SGDFrobeniuses3, color='y', label="SGD3")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDFrobeniuses[run], color='b')
#    plt.plot(GDEpochs[0], SGDFrobeniuses[run], color='r')
# plt.yscale('log')
plt.legend()
plt.title("Frobenius norm of Hessian of GD and SGD on MNIST")
plt.xlabel("Epochs")
plt.ylabel("Frobenius norm")
plt.savefig("Frobenius")
plt.close()

plt.plot(GDEpochs, GDHessianTraces, color='b', label="GD")
plt.plot(SGDEpochs, SGDHessianTraces, color='r', label="SGD")
#plt.plot(SGDEpochs, SGDHessianTraces2, color='g', label="SGD2")
#plt.plot(SGDEpochs, SGDHessianTraces3, color='y', label="SGD3")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDHessianTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDHessianTraces[run], color='r')
# plt.yscale('log')
plt.legend()
plt.title("Trace of Hessian of GD and SGD on MNIST")
plt.xlabel("Epochs")
plt.ylabel("Trace of Hessian")
plt.savefig("Hessian")
plt.close()

plt.plot(SGDEpochs[50:], GDProductTraces[50:], color='b', label="GD")
plt.plot(SGDEpochs[0:], SGDProductTraces[0:], color='r', label="SGD")
#plt.plot(SGDEpochs, SGDProductTraces2, color='g', label="SGD2")
#plt.plot(SGDEpochs, SGDProductTraces3, color='y', label="SGD3")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')3200
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
# plt.yscale('log')
plt.legend()
plt.title("Trace of Hessian and Covariance Matrix product of SGD on MNIST (after 50 epochs)")
plt.xlabel("Epochs")
plt.ylabel("Trace")
plt.savefig("Trace after 50")
plt.close()

GDTestEpochs = np.arange(100)
GDTrainLosses = [1.4272319078445435, 0.3781689703464508, 0.29020315408706665, 0.21597476303577423, 0.18732768297195435, 0.16597279906272888, 0.14940385520458221, 0.136338472366333, 0.12564843893051147, 0.11673016846179962, 0.10917282849550247, 0.10269127041101456, 0.09708043932914734, 0.09216473251581192, 0.08782445639371872, 0.0839664489030838, 0.08050765842199326, 0.07739228010177612, 0.07456377148628235, 0.07198522984981537, 0.06962853670120239, 0.06748541444540024, 0.07361787557601929, 0.7041840553283691, 0.10657583177089691, 0.09309321641921997, 0.08547315746545792, 0.08020420372486115, 0.07613709568977356, 0.07278607785701752, 0.06996596604585648, 0.06755705922842026, 0.06543545424938202, 0.0635378435254097, 0.06182509660720825, 0.06025632843375206, 0.058814480900764465, 0.05747422203421593, 0.056233711540699005, 0.05507468432188034, 0.05398847162723541, 0.05296243727207184, 0.05198672413825989, 0.05106512829661369, 0.05018743500113487, 0.049356743693351746, 0.048567675054073334, 0.0478118471801281, 0.047089919447898865, 0.04640034958720207, 0.045744918286800385, 0.04519021138548851, 0.05004625767469406, 0.5718852281570435, 0.19856759905815125, 0.14173847436904907, 1.4630472660064697, 0.16518473625183105, 0.12424065172672272, 0.10589710623025894, 0.09482517838478088, 0.08712747693061829, 0.08131243288516998, 0.0766923651099205, 0.07288676500320435, 0.06968838721513748, 0.06694333255290985, 0.06456270068883896, 0.06247327849268913, 0.06061480566859245, 0.05894119292497635, 0.057420764118433, 0.05602673441171646, 0.054743632674217224, 0.053552500903606415, 0.05244123190641403, 0.05139991641044617, 0.05042484030127525, 0.04950849711894989, 0.04863809794187546, 0.04781673103570938, 0.04703843966126442, 0.04630015417933464, 0.04559493809938431, 0.044919729232788086, 0.044272590428590775, 0.04365336894989014, 0.04305761307477951, 0.04248083755373955, 0.04192427918314934, 0.04138593748211861, 0.040866319090127945, 0.040365107357501984, 0.03988020494580269, 0.03941209614276886, 0.03895839676260948, 0.038517504930496216, 0.03808946534991264, 0.03767462074756622, 0.037270307540893555]
GDTestLosses = [1.22637912273407, 0.34594747483730315, 0.2644051697105169, 0.19997641146183015, 0.17289245061576367, 0.1527925807237625, 0.13738728076219558, 0.12526067363098264, 0.11533324554562568, 0.10704845597967505, 0.10002903416752815, 0.09403256554156542, 0.08884635206311942, 0.08431648161262274, 0.08032928945496678, 0.07680402177385987, 0.07366827468387782, 0.07085607565939427, 0.06832596464082599, 0.0660420923633501, 0.06397614385932684, 0.06220962789840996, 0.07119245530106127, 0.17687206894159316, 0.09700206065550447, 0.08512139396741986, 0.07829213181510568, 0.07367121597751974, 0.07017848738469183, 0.06730024148710072, 0.06488171426579356, 0.06275330949574709, 0.060854054670780894, 0.05913915600627661, 0.057607432147488, 0.056243986375629905, 0.05499654150567949, 0.05384260379709303, 0.05276933904737234, 0.05176918207667768, 0.05083806460723281, 0.04997026523575187, 0.04915629112161696, 0.04840105019044131, 0.04769827468786389, 0.047041535265743735, 0.04642570006661117, 0.045843341993167995, 0.04529440606944263, 0.04477423682343215, 0.04427007856313139, 0.04379522491246462, 0.050935435625724494, 0.4827382925152779, 0.17576604813337326, 0.12641595169901848, 1.15548057615757, 0.14861202843487262, 0.11208871603012086, 0.09588908081874252, 0.08613190894946456, 0.07927669893950223, 0.07405962398275732, 0.06987620614469052, 0.06642659427598119, 0.0635271568968892, 0.061053200531750916, 0.05890937760472298, 0.057010832731612025, 0.055319087668322026, 0.053800417971797285, 0.05242469374090433, 0.051164670642465354, 0.050005266815423964, 0.04894118208903819, 0.04795314078684896, 0.04704065769445151, 0.0461941200401634, 0.045402675345540044, 0.04466116008348763, 0.043963933745399114, 0.04330956192687154, 0.04269643447827548, 0.042123004510067404, 0.04157860862091184, 0.04106585707515478, 0.040576918160077184, 0.040110095639247445, 0.03966544562485069, 0.03923798864940181, 0.03883038856554776, 0.03844016582705081, 0.038071983125992116, 0.03772456241771579, 0.037393688545562326, 0.03707694217562676, 0.03677655628649518, 0.0364932039915584, 0.03621737356763333, 0.03595703942002729]
SGDTestEpochs = np.arange(200)
SGDTrainLosses = [0.16293295837317903, 0.09279514717869461, 0.08057973242830485, 0.06926685933178911, 0.07452485033621391, 0.058229154342164594, 0.058160809573406975, 0.0507242914797583, 0.038461762350828696, 0.06852400950544203, 0.03179148130429288, 0.0739527265021267, 0.033304172913776714, 0.037230536644735066, 0.03209046007929525, 0.030872714971386207, 0.025182989726793798, 0.051688309477176515, 0.02262312393441486, 0.045497674884585046, 0.020385791284546335, 0.024577002620208076, 0.018583934040701328, 0.018976991074935844, 0.01922787149155435, 0.016622203020281934, 0.015553886457540406, 0.015509852574759862, 0.01509159442963816, 0.058053980762294184, 0.014599253213624859, 0.011927045577419146, 0.013243746126924331, 0.018911853894096567, 0.010988246336334365, 0.014690730380874205, 0.009449913128482876, 0.008979870879823769, 0.020006043594330548, 0.008802089932044814, 0.009789849486163196, 0.00859424915050719, 0.009917902619151087, 0.00949347792348514, 0.0067749607171329745, 0.007414493995638622, 0.007047060895104854, 0.006688215075349338, 0.008235209938090217, 0.005834745546696165, 0.006398788290110436, 0.006457058371294503, 0.005312798492789928, 0.004389316412404393, 0.006274278784815882, 0.004294344784666464, 0.00467580934206732, 0.005516927158265995, 0.005925130522518885, 0.004313413922439698, 0.0035480789431312585, 0.0048139105083222, 0.0031587723460567456, 0.004854213043857574, 0.003330281774027147, 0.0030558478712737268, 0.002842836739088549, 0.0024891586158507077, 0.0026372764833528586, 0.0030700567743876185, 0.003810510937585908, 0.003933170903486219, 0.00276264624938752, 0.0021773881293544644, 0.00213267325631629, 0.0022708939067494307, 0.002256869247554884, 0.0023197782922973905, 0.010754626271367064, 0.0018422203458976583, 0.0055197737582723975, 0.0016487203461580673, 0.0014173234242995628, 0.0014834215941194392, 0.0038773038006623514, 0.001746895596008926, 0.0012183467054031401, 0.01458267316926443, 0.0012648797236761312, 0.001242544377981479, 0.0012176363649556757, 0.0010685960976184105, 0.001018765447104973, 0.000968665163900179, 0.0009071979683524963, 0.0009874096842137684, 0.001104897482952462, 0.00103622979556197, 0.0009517313164057365, 0.0013137503910335606, 0.000826935987441478, 0.0013056087424494459, 0.0007650710956234737, 0.001125251431194556, 0.0010275244210318608, 0.0006687617405680157, 0.0007970921262328072, 0.000776419514901742, 0.000780453146196578, 0.0009737309269718253, 0.000617494084167447, 0.0007355674446015807, 0.0006146098106440453, 0.0005925425454836386, 0.0007027208199466865, 0.0005748880213419246, 0.0005620633106237468, 0.0006067015596469597, 0.0005269809938469431, 0.0005103149681857152, 0.0005751912029374277, 0.0005122670565281359, 0.0005424884552193513, 0.000780620557563149, 0.0004690250919979159, 0.0005764470400627412, 0.0004465308424005343, 0.000454164572654463, 0.0006437632228403345, 0.0004822195667300851, 0.00046514378788932236, 0.0004391293524129954, 0.00043476281249430333, 0.0005547036747126792, 0.00038950331021851524, 0.00040013684372809167, 0.00038280784047458385, 0.000373943369047538, 0.0004337961357665184, 0.00036770328483423024, 0.0003580593178818011, 0.00034980941828545534, 0.0003550733064537326, 0.0003475808398764002, 0.0003550459063460683, 0.00032786703334788096, 0.00035144872429095623, 0.0003281486939451857, 0.0003352223078085596, 0.0003335211541169277, 0.0003241902871919441, 0.00032934530804179, 0.00030997699541406595, 0.00033768156126380214, 0.0003517924709541376, 0.00029693200195614127, 0.0002909355903082182, 0.00028738199121714083, 0.00030353634411919, 0.0002903991354359429, 0.0002858856084007281, 0.0002896920469942188, 0.00027231498652478575, 0.00028548809312184176, 0.0002615198792134758, 0.000265144310311977, 0.0002680499064202498, 0.00025984960556494724, 0.00026353142242063163, 0.0002753069242065938, 0.0002481090207993475, 0.00024359780442694044, 0.00024155688599942474, 0.0002515489760908925, 0.00024436158978573985, 0.00024916054838267126, 0.00026246459647988254, 0.00023419549603351204, 0.00022858564886898118, 0.00022871599237324366, 0.00024371291305333404, 0.00022533220314149578, 0.00022379626911610254, 0.00022114624421362805, 0.00021262055753761426, 0.00023265101814985202, 0.00022037332712272927, 0.00021191679309841524, 0.0002132650780047148, 0.00020274542887866194, 0.0002041374345688496, 0.0002146684344758872, 0.00019811495431393194, 0.0002603947663923615, 0.00019333508982441572, 0.00019417661702789246, 0.00019575410693088694, 0.00019109122650178277, 0.00018982507701821306, 0.00021236586526773258]
SGDTestLosses = [0.15549129776656628, 0.08289240945130587, 0.07916134834289551, 0.06558951686136424, 0.07812253633514046, 0.05586932481266558, 0.0628401994612068, 0.048992314101196824, 0.040089864018373195, 0.06510765539947898, 0.035074483391363175, 0.07350492871366442, 0.03972110010683536, 0.04084129548165947, 0.03627982697216794, 0.03890654582064599, 0.035096385180950165, 0.06452181838452815, 0.030907076476141812, 0.060722224870696666, 0.03147335394169204, 0.040676414580084384, 0.031095652527874336, 0.03156214454967994, 0.03300449605914764, 0.03095953035634011, 0.03004843547329074, 0.030217696560721378, 0.030812983058858663, 0.07827857570257038, 0.031111020502285102, 0.030081089392770082, 0.03214254864025861, 0.035628876045229844, 0.03027371586882509, 0.03526165063027292, 0.029729228440555745, 0.030925295410270337, 0.04126854851376265, 0.03213947481533978, 0.0337560191337252, 0.031330587898264636, 0.03339339380647289, 0.033903708016150634, 0.03097073464508867, 0.03299212810321478, 0.03295109855156625, 0.032644618630292825, 0.036205113249161515, 0.03201343109729351, 0.03360940694037708, 0.03478039550594986, 0.034859837154945124, 0.03331409902748419, 0.03621138030575821, 0.033418821912164276, 0.035848757661806306, 0.036377423961821476, 0.036249496410164284, 0.034897601789562034, 0.03494567386427661, 0.03677245751794544, 0.03488305469225452, 0.037609481482577395, 0.035471529495152934, 0.0359574988615077, 0.03536073929120903, 0.03685667652160191, 0.0366576616387465, 0.038134484110269116, 0.04060706733696861, 0.03912436544313096, 0.03762145034997957, 0.03679024079821829, 0.03907936384282948, 0.03973622502679063, 0.04180117757361586, 0.03928981678756827, 0.05675076448766049, 0.03983814167581386, 0.04459916360217903, 0.03969635985316927, 0.04082659820098342, 0.041483323882966945, 0.04634967394446449, 0.04101211673783837, 0.040460653789778006, 0.05706371730644605, 0.04174387117556762, 0.041516872764914295, 0.04239823085194075, 0.0415242436488461, 0.042264090609151025, 0.04307590663102019, 0.041765167934772765, 0.04230339619309234, 0.04375086280168034, 0.04319093468759092, 0.04300863202857727, 0.0449592860925668, 0.0446150392259915, 0.044311098504952046, 0.043320273913559505, 0.04458686587522607, 0.04462805782968644, 0.0436797277335063, 0.043364116763477796, 0.043782753134894395, 0.045429797573438006, 0.046007269826232, 0.0444467208878541, 0.0453777296770204, 0.04469333233917155, 0.04549383875068998, 0.04678153359668613, 0.04577293198104144, 0.04518598517186547, 0.045670649345065616, 0.04552000952770413, 0.04584061044644841, 0.045750577303138015, 0.04609230703924368, 0.04616769466069855, 0.04724824326156522, 0.04660953616943516, 0.04702846966200695, 0.04633786425894868, 0.046697133008508446, 0.04815639140750136, 0.047087051103571864, 0.04721327700605798, 0.04754198310567517, 0.04772623753084417, 0.04804440597381472, 0.04749606407578995, 0.04805737873428825, 0.04804299301024002, 0.04834777184702034, 0.047984534842257745, 0.047911406381499544, 0.047581787405263185, 0.04810623202510669, 0.04811377696607451, 0.04821919074392099, 0.048366518489629015, 0.04834049030600454, 0.04835704788397152, 0.04841510353233844, 0.04900026407432961, 0.04897656211847107, 0.04894179024669256, 0.049430912275461196, 0.04896814339992716, 0.05016064852085037, 0.05034569746083548, 0.049458098032491765, 0.0495601012174393, 0.049922722953206176, 0.05040799027273124, 0.04954340858767523, 0.049559808846352096, 0.04983472207081377, 0.05006010075143422, 0.05040599561072184, 0.05009015524449751, 0.05055159939848693, 0.05071218144647901, 0.05080798273760592, 0.050258190642534825, 0.05101411776675149, 0.05085546734839227, 0.05078793581364607, 0.05094805855613913, 0.05149632375294914, 0.050565478545404545, 0.05127682026102036, 0.051195715199091864, 0.05088325785820644, 0.05141789098867321, 0.05151642861066989, 0.051943762125192736, 0.0516416566751991, 0.05131346684338041, 0.05191306157580243, 0.05184142133377463, 0.05211676928893667, 0.05175661527281136, 0.0516132249021797, 0.05212515641039772, 0.05184720962430021, 0.05180417949043601, 0.051879369380305886, 0.05184357636402183, 0.05223418695557541, 0.05255107861803026, 0.05268353939983626, 0.052898458144263714, 0.05255933854621617, 0.05248405192847258, 0.05283155418728938]
plt.plot(GDTestEpochs, GDTrainLosses, color='b', label="GD")
plt.plot(SGDTestEpochs, SGDTrainLosses, color='r', label="SGD")
#plt.plot(SGDEpochs, SGDProductTraces2, color='g', label="SGD2")
#plt.plot(SGDEpochs, SGDProductTraces3, color='y', label="SGD3")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
# plt.yscale('log')
plt.legend()
plt.title("Train Losses of GD and SGD on MNIST")
plt.xlabel("Epochs")
plt.ylabel("Train Loss")
plt.savefig("TrainLosses")
plt.close()

plt.plot(GDTestEpochs, GDTestLosses, color='b', label="GD")
plt.plot(SGDTestEpochs, SGDTestLosses, color='r', label="SGD")
#plt.plot(SGDEpochs, SGDProductTraces2, color='g', label="SGD2")
#plt.plot(SGDEpochs, SGDProductTraces3, color='y', label="SGD3")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
# plt.yscale('log')
plt.legend()
plt.title("Test Losses of GD and SGD on MNIST")
plt.xlabel("Epochs")
plt.ylabel("Test Loss")
plt.savefig("TestLosses")
plt.close()
'''
SGDTrainEpochs = np.arange(500)
SGDTrainLosses = [0.45806680793563526, 0.3933880303800106, 0.39047456776102385, 0.3532802214473486, 0.3198851814121008, 0.3152654374142488, 0.27508683731158573, 0.28830387074500324, 0.26319949301580586, 0.2528858276456594, 0.2510892441868782, 0.25109222419559957, 0.2873082619657119, 0.22647174242883922, 0.24989114176481964, 0.22666640748580297, 0.2061489913860957, 0.20119606457650663, 0.20337445633485912, 0.19814287801583608, 0.20320330206304787, 0.21131402040521305, 0.18220574957629046, 0.18327824274698892, 0.18484422657017907, 0.19126952273150286, 0.1919778394823273, 0.20896352251370748, 0.17231939231976867, 0.15851493823652466, 0.17061822482074301, 0.1516364969437321, 0.16440755467241008, 0.15570438411086798, 0.1476900721465548, 0.13787328960063558, 0.15368550583099325, 0.1445880767889321, 0.1355539527659615, 0.14445929505551855, 0.16619819521903992, 0.14398070770626267, 0.12921864697709678, 0.12266931123410663, 0.15434500582826635, 0.12800488772491614, 0.12524414013450344, 0.14934319191301862, 0.10560170470116038, 0.10740001786189775, 0.10584213763475418, 0.14024582978958886, 0.1136429727015396, 0.09951816707539062, 0.09947047730286916, 0.13984180526187023, 0.19269712847967943, 0.09610706494189798, 0.13733162206908067, 0.11410861387848854, 0.09343581361696124, 0.10409303256000081, 0.11174725401525697, 0.0824554375745356, 0.08192191662887732, 0.08063708710794648, 0.08785077127783249, 0.0764974466478452, 0.08966009475290776, 0.07301598857156932, 0.07310049126235148, 0.06332237404771149, 0.08162572565488517, 0.0645620702408875, 0.1459175600639234, 0.07483461400028318, 0.1137651483900845, 0.07263569758894543, 0.05244211153437694, 0.07035009644925594, 0.05559615690571566, 0.0610480087591956, 0.05417852070337782, 0.05912820006720722, 0.05232570413965732, 0.051244149290335675, 0.08283669416637471, 0.05667751686104263, 0.05852115301260104, 0.042734375963918866, 0.05066143397862712, 0.05918464662351956, 0.047051536971703174, 0.037127250945971656, 0.05266286702050517, 0.039269358394667504, 0.033882552652309335, 0.0429031616775319, 0.03702625465036059, 0.042927558480296286, 0.05468984100734815, 0.04800809041674559, 0.06328462422514955, 0.10028582782795031, 0.027552642291411758, 0.02793402675112399, 0.03647504297162717, 0.029201035726970682, 0.03465729075406367, 0.05040774478460662, 0.02444264491243909, 0.04748171888679887, 0.02455595897200207, 0.02434669901578066, 0.018844003474805505, 0.06933538382096836, 0.02066378085524775, 0.04571868776848229, 0.0269137210616221, 0.02584445056001035, 0.026634406911519668, 0.017447857799901007, 0.01448870128680331, 0.0181056529438744, 0.0401810602688541, 0.034821932311557856, 0.013569016600764977, 0.015390392713015899, 0.012235256011287372, 0.018370593726673785, 0.01777703834658799, 0.018210418384793835, 0.014113798261387273, 0.0177928221578865, 0.011205455956902977, 0.029287492349200573, 0.013437382222812932, 0.010431039497683136, 0.015192565516917967, 0.013347883341678728, 0.00901749284278291, 0.009912678193068132, 0.009753248727065511, 0.009090431117995953, 0.005437120600157262, 0.006295842927259703, 0.0065933194337412715, 0.006636989076408402, 0.005527588279510383, 0.00594614352992115, 0.004603339200548362, 0.00913734657903357, 0.004257044817689651, 0.005642284073207217, 0.004025929505199505, 0.003706486513838172, 0.003950209723164638, 0.003577718753076624, 0.005888344341365155, 0.0033811979006471422, 0.0038067693353514187, 0.003036937539485128, 0.03244303010617538, 0.003137109563103877, 0.002982345618462811, 0.0031790872190807324, 0.0030167041068489197, 0.0030553693577530794, 0.002850670671808378, 0.002774557335069403, 0.0026482162345200775, 0.0027234015735060286, 0.002514907286677044, 0.002613375777048835, 0.002364230379074191, 0.002415978602463535, 0.0024277884094044567, 0.0023186948467143033, 0.002269007237725115, 0.002260622409424589, 0.002192558772561218, 0.002220931649693133, 0.002139970781766654, 0.0021989701040729414, 0.0020624803578539286, 0.002138568196144964, 0.00204264293332623, 0.002020580213575158, 0.0019715998559937968, 0.001973734817778071, 0.0018188685743371026, 0.0018579273142192202, 0.001793569009945107, 0.001905183768782687, 0.0017298275754243757, 0.0017563980192062444, 0.0017225829039428694, 0.0016762038993571573, 0.001682414032208423, 0.0016704072126594838, 0.001599525046525135, 0.0015856632773162953, 0.0015595783198902307, 0.0016004643907460074, 0.0016047170295011408, 0.001655974972018157, 0.001484141690598335, 0.0014726066592265852, 0.0015253060901644251, 0.00154871930021424, 0.001545215808728244, 0.001383782371704001, 0.0014601473936636466, 0.0014086343041465929, 0.0013882469457651798, 0.00137577777907912, 0.001331169469873809, 0.0013194684683791517, 0.0013717139246000442, 0.0013862173873834156, 0.001254456375609152, 0.0013672683745486816, 0.001294343586208318, 0.001258947414510961, 0.0012879821437915477, 0.0012336836854713814, 0.001233465136610903, 0.001204308557304709, 0.001252848533404176, 0.0012015791598241777, 0.0011814615824550857, 0.0011547022020143535, 0.0011429883363113429, 0.0011374635882627142, 0.0011144693611519567, 0.0010996645017682263, 0.0011166050093743252, 0.0010911147573400134, 0.0010575387440621854, 0.001059087798106096, 0.0010479885118062763, 0.0010671643225456744, 0.001020299091784788, 0.001055052746499617, 0.0010165498869415994, 0.0010239885853419158, 0.0010649029403187644, 0.0010122559251612984, 0.0009745768310434262, 0.0009916315488953842, 0.0009893812535786612, 0.0009716875880743221, 0.0009767926486044113, 0.0009513212904615405, 0.000933256675125449, 0.0009675847918212336, 0.0009349504174800434, 0.0009171488224577237, 0.0009134890561593542, 0.0009011956338023689, 0.0008895030780452847, 0.0008902144274179591, 0.0008757062526516771, 0.0010001782177520605, 0.0008755736740325423, 0.0008820085647312226, 0.0008534676374013846, 0.000847380161236894, 0.0008589229030136873, 0.000838952214398887, 0.0008408658153105838, 0.0008374469809011013, 0.000819471450340643, 0.0008188649387981665, 0.0008348922384902835, 0.0008158273277028154, 0.00082512739457646, 0.0008116314876436566, 0.0007834341034322279, 0.000815822540850301, 0.0007612060288132246, 0.0007708194270041228, 0.0007677193805284332, 0.0007621136854140786, 0.0007543036898520465, 0.0007578192294992429, 0.0007503242386398294, 0.0007318637164280517, 0.000726707480813881, 0.0007218941051663326, 0.0007253467895740565, 0.0007515487876419987, 0.0007163458597642603, 0.0007038209832050294, 0.0007380370267492253, 0.0006910478556043624, 0.0007277491133087702, 0.0006878913519176422, 0.0006819935547294638, 0.0006786370665213326, 0.0006672422884730622, 0.0006676690548435241, 0.0006697441671713023, 0.0006563886560373551, 0.0006765528816807395, 0.0006472680696363871, 0.0006421482196553067, 0.0006507113460490169, 0.0006432941877574194, 0.0006336605705534263, 0.0006784186954610049, 0.0006492833241524446, 0.0006360568268792122, 0.0006308304732859445, 0.0006116897185468891, 0.000620993364379198, 0.0006151467136927143, 0.0006179320481654334, 0.0006136374871372634, 0.0006176579484478376, 0.0006072722926304171, 0.0006097482328853706, 0.000593288273497213, 0.0005866429927603652, 0.000581758158696175, 0.0005773882352392926, 0.0005794462854343389, 0.0005883705719315912, 0.0005856711908563738, 0.0005681466029636795, 0.0005680486192189468, 0.0005749848149086271, 0.000562404191296082, 0.0005552234539451698, 0.000562757585576037, 0.0005506074568620533, 0.0005579934775111421, 0.0005424728031357517, 0.0005503586322508151, 0.0005347824872903099, 0.000536795233359347, 0.0005326058863768898, 0.0005299717497109669, 0.0005289952076418558, 0.0005270849439693848, 0.000519361831053781, 0.0005184672765972209, 0.0005275939372950233, 0.0005122800671476095, 0.0005129576536395083, 0.0005138640883402938, 0.0005101733788130028, 0.0005137614113724946, 0.0005048068286608516, 0.0004958709461182783, 0.000496104813155398, 0.0004979568615938964, 0.0004963794709813859, 0.000493263670274852, 0.0004891302048781654, 0.0004915502912141771, 0.0004778533655917272, 0.000493457542906981, 0.00047867234660467755, 0.00047894036387636634, 0.0004748139195604987, 0.00047031915117258906, 0.00046973953783890465, 0.00046914904486281255, 0.00047489614856507006, 0.0004662942713912344, 0.0004621007311955812, 0.00045680679640402864, 0.0004578939895024329, 0.00046603217503919344, 0.00045441434045642384, 0.0004523771231470164, 0.00044826062985521277, 0.00044878466818772724, 0.00044263861689008386, 0.0004473397584539877, 0.0004438458704438138, 0.00043655742077438237, 0.00043857554698964425, 0.00043488291014606755, 0.00043881195949021883, 0.0004334312669864933, 0.00043888304817907433, 0.00043579620203672677, 0.00042610440442028146, 0.0004227748109406093, 0.00042261801309602257, 0.0004244747617243168, 0.00041597398617644404, 0.00042075857693513776, 0.00042225700741255423, 0.0004151338984593167, 0.00041645556670118824, 0.00040974217574936726, 0.0004102471817168407, 0.0004117383200597639, 0.00040569944509722213, 0.00040867885237579076, 0.0003999435291310268, 0.0004017110731365392, 0.000402409387655401, 0.000398173363537353, 0.0003935924900967317, 0.000398959411316658, 0.0003922964839512133, 0.0003896018714173503, 0.00039797399106949647, 0.0003847234219817134, 0.00038433464462286795, 0.0003823013845006547, 0.0003868527551336835, 0.0003817513937004454, 0.000383306399853609, 0.0003783857016848439, 0.00037433682872991386, 0.00037713313329732043, 0.00037638255815181765, 0.0003721848576606135, 0.0003758898474673818, 0.00037004156489274466, 0.0003669471329703811, 0.0003692884643775566, 0.00036355636430622935, 0.00037378735477735364, 0.00036796351608548626, 0.00036371172317255213, 0.0003612811301839732, 0.00035692424065928205, 0.0003563364838070508, 0.0003637408664144459, 0.0003608564903940229, 0.0003583345404816403, 0.0003765291816671379, 0.0003512839298249067, 0.0003487843874124034, 0.0003491523871586348, 0.0003478461359433519, 0.00034619982508350705, 0.00034428074766765346, 0.0003464796915613988, 0.00034362864431993027, 0.0003422721050446853, 0.00034618663906561174, 0.00033718999212093575, 0.00033575252826873717, 0.0003342718847185703, 0.00033533353052916937, 0.0003340528344415361, 0.0003353826992558121, 0.0003306245640366493, 0.00032918090919944613, 0.0003310214728783952, 0.000327667965029832, 0.0003272112516606285, 0.000324947857746641, 0.000324975881097392, 0.00032598661697799496, 0.0003240688450265831, 0.00032162582346548636, 0.00032111996987926737, 0.00031801463024142625, 0.0003174130088276191, 0.0003177129807833505, 0.0003158357796746714, 0.00031757585561232796, 0.000313955506462662, 0.0003125475458000437, 0.0003111287421294643, 0.00030989293533518016, 0.00030974235402027263, 0.000311710569767456, 0.0003109229890227046, 0.00030594007378870934, 0.0003065697966727991, 0.00030524981367610355, 0.00030924989441700746, 0.0003016681272977924, 0.0003008301052492849, 0.00030041182943629487, 0.0002995054198072467, 0.00029959831581436445, 0.00030568232763471313, 0.00029644036508822563, 0.0002992557902931973, 0.00029562010295194343, 0.00029637856809131333, 0.00029289551723195474, 0.0002979500356620216, 0.0002973144493868555, 0.0002936999673571942, 0.0002891986815666314, 0.00029096832363696495, 0.00028865036440038237, 0.0002881299906524267, 0.0002857638179436132]
SGD10TrainLosses = [0.47032101025184, 0.3969556083281835, 0.3606947941581408, 0.3402572438120842, 0.31954283309479553, 0.3066481989125411, 0.29567393340170384, 0.2870527373502652, 0.2748464270556967, 0.2678456348056594, 0.26060177251696587, 0.2546035036444664, 0.24957462617506584, 0.24113092492024105, 0.2363581379254659, 0.24425207038720448, 0.23505379186322292, 0.22997212847073872, 0.22909193240726988, 0.22371471570183835, 0.2184952827791373, 0.21222721219062804, 0.21279525805264712, 0.22170827466994525, 0.20636178441345693, 0.204411783653001, 0.20067028361062209, 0.196967898743848, 0.19408876145879428, 0.19813659034669398, 0.18873643033206464, 0.19567677408456802, 0.18444020661214988, 0.18268872956434887, 0.18312375088532765, 0.17910716144988933, 0.17571383081376551, 0.17228571935246387, 0.1699689488609632, 0.17588443345079818, 0.16746565299108623, 0.16710855771477023, 0.16468480243037145, 0.1631349290907383, 0.1594337339513004, 0.16184595625847578, 0.16040035987893742, 0.15241978840281567, 0.16306947358573476, 0.15003548494229715, 0.15114743356903393, 0.14767519149308403, 0.14589628893882037, 0.14767515428364278, 0.14776281726236146, 0.1459914991632104, 0.14113665082181492, 0.1405058647505939, 0.14043829667692384, 0.14692598333582282, 0.13651521739239494, 0.1441652892778317, 0.1282178865559399, 0.12832992025340598, 0.1290173200145364, 0.13191023654614886, 0.12552286832903822, 0.1235488084393243, 0.1201575094461441, 0.11574297054981192, 0.11647388622785608, 0.11380664631724358, 0.12040597525114814, 0.12531019957736134, 0.11010557730371753, 0.12508696626250942, 0.10623087047909698, 0.10858761007276674, 0.1027172776311636, 0.1111965820317467, 0.10323548641676704, 0.10103820782154799, 0.09850158740455905, 0.09479684070373574, 0.09785633943974972, 0.10017365530133247, 0.09463174042912821, 0.08876520622832079, 0.10391437254846096, 0.08738108613528311, 0.0844225559104234, 0.0926138225197792, 0.08484592876397073, 0.08279764896569153, 0.08026809424782792, 0.09311311950596671, 0.07865135950036346, 0.07767867802642286, 0.07460949917323888, 0.07486693947575987, 0.07817970898312827, 0.07996587117823462, 0.06657820153981447, 0.07156095571195085, 0.06657392269310852, 0.07003918851725757, 0.07100319811453422, 0.06326725166290999, 0.059325219336897134, 0.0964792004507035, 0.0640795313504835, 0.0640630373172462, 0.05678305076745649, 0.1412464408700665, 0.056552897250900666, 0.051688523637130855, 0.05191983441201349, 0.05493038962284724, 0.05663768890624245, 0.050722392372166115, 0.08384850204301376, 0.04424891625841459, 0.050763640605534115, 0.043493304848670956, 0.044362352723255755, 0.04054825223361452, 0.040186866126023235, 0.03820379561899851, 0.04228346894029528, 0.15690052215009928, 0.1417326663341373, 0.03608481318069001, 0.046801625235627094, 0.039788539704556265, 0.04277619840887686, 0.0326435560042349, 0.04607883685113241, 0.032435138770767175, 0.029316972244220474, 0.0658024097311621, 0.02875669830944389, 0.04819815264238665, 0.0380277557997033, 0.02898469543317333, 0.028459679784718903, 0.026049374293070287, 0.032122211618504176, 0.02555359909310937, 0.022598169463065764, 0.024563306108272325, 0.02711522243839378, 0.025746053374993305, 0.020731637689750643, 0.022623901350113253, 0.04593020444968715, 0.02427138192889591, 0.0300616801266248, 0.039084115248018254, 0.13410813333621868, 0.021046389838835847, 0.02721294711343944, 0.01848969207960181, 0.04301383880277475, 0.025147633898692828, 0.02341601358881841, 0.01662200639412428, 0.02096419541553284, 0.010567129810806365, 0.009849318160947102, 0.10377465940235804, 0.015068095399765297, 0.46759889004131155, 0.0197991781666254, 0.03261115890306731, 0.1092517246476685, 0.01676559802183571, 0.14225170144811272, 0.03020968454851148, 0.036242237684394545, 0.0106866865195722, 0.00841944760895179, 0.0077147060687032835, 0.005198524075094611, 0.004614620540911953, 0.004511423692456447, 0.004675312294857577, 0.00393156575174847, 0.0036555850798807416, 0.0035105618717110095, 0.0032858123935875483, 0.003202526760578621, 0.00306879202175575, 0.0029510526190279053, 0.0028347216302063317, 0.0028172836312054038, 0.0026630420686948736, 0.0026121145875852864, 0.002580716053683621, 0.0025037601845300135, 0.0023865148588083683, 0.00235511773188288, 0.002287310223716001, 0.0022528458797023633, 0.0021721561714366545, 0.002128801917327413, 0.0021031588265517107, 0.002047417988748445, 0.0020017318955797237, 0.0019530930187708388, 0.0019307117194208938, 0.0018881937571859453, 0.0018634486954154756, 0.0018335305055855618, 0.001793332479816551, 0.0017736747814342379, 0.0017308524067144997, 0.0016997169645037503, 0.0016912099866506953, 0.001671992053646439, 0.0016569817738006046, 0.0015965376362631408, 0.0015851500884067112, 0.0015423769557188886, 0.001526546971241866, 0.0015002908208892525, 0.0014863777506009986, 0.0014650325187055085, 0.0014350858443746499, 0.0014215352515263172, 0.0014087562252825593, 0.0013864419502594197, 0.0013628727334435097, 0.0013474340809625574, 0.001329079921755086, 0.0013104423863114789, 0.0012991477135801688, 0.0012860688674360668, 0.001269325812900206, 0.0012497207443811931, 0.0012314404641316893, 0.0012261686585164475, 0.0012097139509084324, 0.0011926906252241072, 0.001190385181447103, 0.0011724040600529406, 0.0011515296287931656, 0.0011388355150605397, 0.0011348076509602833, 0.0011222213094879408, 0.001102974300229107, 0.0010902666978654452, 0.0010797120472610306, 0.00106503659056519, 0.0010580895780488693, 0.0010457654943456874, 0.0010327671126287895, 0.0010285376572574023, 0.0010240840655266462, 0.0010026693672989496, 0.0009945440362207592, 0.0010045914935957018, 0.0009788928633982627, 0.0009691146001083932, 0.0009627649395891543, 0.0009494488841301063, 0.0009474671053370306, 0.0009372701592898617, 0.0009246128559607314, 0.0009182509869424394, 0.0009103570594500828, 0.0009105003702279646, 0.0008926538708571267, 0.0008909949165778623, 0.0008783507769355007, 0.0008710278620613584, 0.0008620877556677442, 0.0008558069581583065, 0.0008473251053025402, 0.0008426485233697653, 0.0008411389599253501, 0.0008271510884515009, 0.0008210170390763476, 0.0008151673451357055, 0.0008101466755518535, 0.0008029721466300543, 0.0007968663334759186, 0.0007910082704377904, 0.0007904770336123572, 0.0007776326005841838, 0.0007720596343521416, 0.0007673262252501445, 0.0007668778593506432, 0.0007584286357450765, 0.0007502613578011126, 0.0007459970693162177, 0.000738309043905853, 0.000733648112048589, 0.0007322402816983715, 0.0007251109652133891, 0.0007192647677341787, 0.0007130402458036164, 0.0007096920818003128, 0.0007073982201594238, 0.0007015210677248736, 0.0006936461935886958, 0.0006901432399899932, 0.0006840835165106303, 0.0006793685956896904, 0.0006771434577725207, 0.0006794854918310496, 0.0006696090714103775, 0.0006639915963751264, 0.0006601399362261873, 0.0006555048648927671, 0.0006497917367353996, 0.000647134834677369, 0.000641989269691597, 0.0006403431221648741, 0.0006333753789173594, 0.0006300769242322228, 0.0006265485506689099, 0.0006238128884191004, 0.0006178352106750632, 0.0006147373469866579, 0.000612895006100492, 0.0006069923821875515, 0.0006050773038926612, 0.0005999389755015727, 0.000597278458129343, 0.0005950701391702751, 0.0005900743210319585, 0.0005864350206926853, 0.0005836773375267512, 0.0005829433191926606, 0.0005776553248385123, 0.0005726389696064871, 0.0005695798046266039, 0.0005670079399230114, 0.000563432006892981, 0.0005608289237958767, 0.0005571803980031594, 0.0005540046349293941, 0.0005518185104544197, 0.0005482062423106982, 0.0005452285388067443, 0.0005433165563590592, 0.0005406138280644276, 0.0005377475066658614, 0.0005334702712328483, 0.0005313949140448433, 0.000527436905297994, 0.0005245252268893334, 0.0005224372774318909, 0.0005192302320695792, 0.000517256795950137, 0.0005144589680033581, 0.0005112546715948459, 0.0005101262094831327, 0.0005064170665233784, 0.0005035490025329637, 0.0005012814278840475, 0.000498870814080874, 0.0004973238313687034, 0.000493443339607135, 0.0004917271632196692, 0.0004901295334396612, 0.0004876514292603436, 0.00048396012192824855, 0.0004825561605442393, 0.0004803157817029084, 0.0004775308745229268, 0.0004749519730709532, 0.0004748488779781231, 0.0004716041304466974, 0.0004705233765465285, 0.0004663138784599141, 0.0004647230681075598, 0.0004621598258988039, 0.0004609092812218781, 0.0004570642683999419, 0.00045652090640942335, 0.00045312645476466666, 0.00045133128257778785, 0.0004492384771704868, 0.00044780866326618704, 0.0004459066765048192, 0.0004433880387902415, 0.0004409619001550406, 0.00043929977900309796, 0.00043764330392150443, 0.0004363102204782384, 0.00043342489191369775, 0.00043147326605928054, 0.0004292097744473722, 0.00042948912787930265, 0.0004278620532932109, 0.0004239967577086645, 0.00042211221007164567, 0.0004202071252075257, 0.0004185554567569246, 0.00041663738389615903, 0.00041477775860888265, 0.00041412872434496724, 0.0004114986378893567, 0.0004099760478978472, 0.00040805918473779456, 0.00040702551870102374, 0.00040522559718131866, 0.00040336098605621375, 0.0004011923855432542, 0.0004007938422607064, 0.00039858459139698727, 0.0003977692754051532, 0.00039552154220776477, 0.00039577014689712086, 0.00039161461894157885, 0.000390623279333037, 0.0003888731555707636, 0.0003871883519362503, 0.00038625803788211975, 0.0003844647312507732, 0.00038313451487435185, 0.00038092897074723926, 0.0003807009898810065, 0.0003778513266054991, 0.0003776376274496821, 0.0003753456644092997, 0.00037415668658165183, 0.0003724074449686062, 0.0003707301056905029, 0.00036938000082348786, 0.0003679685784542623, 0.0003675327725431998, 0.00036508737421778886, 0.0003637142349786397, 0.0003624292647752251, 0.0003608698139093273, 0.0003610980819454805, 0.00035845357923487123, 0.0003573391990903474, 0.00035606718985945916, 0.0003545807264648223, 0.0003547084248990965, 0.00035234277330649394, 0.0003505996365735579, 0.00034929725484592685, 0.000348060490481051, 0.00034683972917264326, 0.0003466099366778508, 0.0003445086179878369, 0.00034371944002487, 0.0003419932488031918, 0.0003412693836313944, 0.0003398940719853272, 0.00033827784813183825, 0.0003376316701542237, 0.00033654977420762103, 0.0003346255883904329, 0.0003338686830102233, 0.00033287350310274634, 0.0003321425658092873, 0.0003302404604498103, 0.00032980639732462197, 0.000328423566922235, 0.0003271066125186432, 0.0003260020410743891, 0.00032465224799428443, 0.00032376290702207676, 0.00032284639918846853, 0.0003217454007123403, 0.00032024064958629123, 0.0003203360546346327, 0.0003181673762446735, 0.0003178235375647394, 0.00031606728620924213, 0.0003150927635942935, 0.0003141029556718422, 0.0003135418707461213, 0.00031199302337578654, 0.0003114121787317951, 0.0003101792714369367, 0.00030870295921583117, 0.0003078791726390288, 0.00030669405652588466, 0.0003062675171531737, 0.0003052688565973464, 0.0003041754134877313, 0.00030308936247214056, 0.00030228263118866987, 0.00030133595969649227, 0.00030024176511991147, 0.00029936795982697125, 0.0002989301395427901, 0.0002974410861255213, 0.0002965280228454503, 0.0002957436868988831, 0.00029479119375537267, 0.0002941167735601387, 0.0002929131899630496, 0.00029181905745645053]
SGD20TrainLosses = [0.4966888876756032, 0.4076195587217808, 0.3712428806225459, 0.34930331103503703, 0.3301420905192693, 0.31670536316931247, 0.30450431182980536, 0.2939801828066508, 0.28632439382374286, 0.2788366736471653, 0.2722023645788431, 0.2668354248255491, 0.2615897396703561, 0.25467221630116305, 0.2488096925492088, 0.25520809846619763, 0.24564354307949543, 0.23982875917106866, 0.24061777234077453, 0.2349279921501875, 0.23099702275047698, 0.22571806299189726, 0.2256339149052898, 0.22758696717520555, 0.21968231881658237, 0.21573092615852754, 0.2137788803006212, 0.20891677270332973, 0.2084216570109129, 0.20958310039093098, 0.20377969450006883, 0.20542269570132096, 0.20062702083339293, 0.19643090880165498, 0.1973469746237, 0.1938987234731515, 0.19170136943459512, 0.18840611968189477, 0.18537988662719726, 0.1925661626085639, 0.18305923470606406, 0.1817771694312493, 0.1800293991342187, 0.17896788358688354, 0.17490188306818405, 0.17581463358054558, 0.1738397936647137, 0.17098569308718045, 0.17574267103026311, 0.1680431484679381, 0.16976692306498686, 0.1655614608898759, 0.16285358221580584, 0.16747528947268922, 0.1614639104778568, 0.1645568220814069, 0.1575031167641282, 0.15767680157596867, 0.15796530359735092, 0.16014062601452073, 0.16063063696026803, 0.15923210144042968, 0.1481975374246637, 0.14658870744208494, 0.14666234359145164, 0.14760103232537708, 0.1465177714576324, 0.14288460342834394, 0.13821159598107138, 0.13537584333991012, 0.135317125475655, 0.13369917327538133, 0.1388974379375577, 0.13946541789298256, 0.12921546462302408, 0.1362761950182418, 0.1278347385302186, 0.127958285578837, 0.12565889118860166, 0.13457914486527442, 0.12451637260615826, 0.12398854584122697, 0.12003849608823657, 0.1172512669954449, 0.11756699219966928, 0.11640931650996209, 0.1156589859413604, 0.1119508236584564, 0.1268564813832442, 0.10866538578644395, 0.10755674129351973, 0.11451779532556733, 0.10623283591742316, 0.10955165648212035, 0.10332992622007926, 0.10098347189525764, 0.0991966530525436, 0.09912229703428845, 0.097106047347188, 0.0989840052401026, 0.09636193140099446, 0.09704822811608513, 0.09409371454579135, 0.09004019427113236, 0.08815739759554465, 0.09074645217508077, 0.08691920823107163, 0.0843757849217703, 0.08212387105450034, 0.08599882785230875, 0.08237330997362732, 0.08364737110212445, 0.07789501195463042, 0.08879290731623769, 0.08210537316277623, 0.07415166861377656, 0.0802487538382411, 0.07706362484333416, 0.08151416016742587, 0.06875277273667356, 0.08052457547125717, 0.06406771033381423, 0.06513743202357243, 0.06323739257951577, 0.06707718592137098, 0.062201794159288205, 0.05845438062523802, 0.058115948401391504, 0.060756739238277076, 0.06954696772930523, 0.11921098640188575, 0.05346458569169044, 0.0596456123329699, 0.05224630197820564, 0.05280640870022277, 0.04714944049095114, 0.052108630631119014, 0.046247935617963476, 0.044910795274190604, 0.04784937864324699, 0.0422637757503738, 0.05610942873638123, 0.04455253895372152, 0.05010898477863521, 0.06480216526271154, 0.04412018456185857, 0.0373081941716373, 0.037376068149072426, 0.03607629122134919, 0.036249876178335395, 0.03257097582798451, 0.03269055210053921, 0.031344816673081366, 0.041860389447150134, 0.032496378031404066, 0.0383176912041381, 0.02911453752235199, 0.04262814241539066, 0.026745014634604256, 0.03135007726494223, 0.035327694029547274, 0.23854157959421476, 0.02698166682617739, 0.028079148155326646, 0.03498177213904758, 0.03396599193103612, 0.03845816566065575, 0.044255269949013985, 0.26868125699460504, 0.04240947616519406, 0.019257455311793212, 0.033015473733345665, 0.02278422388403366, 0.023989708706115682, 0.034463554158185916, 0.028847055377749106, 0.02384766013128683, 0.024485396951592218, 0.024724681733641774, 0.018759083135519175, 0.019833269156709625, 0.02775833376450464, 0.018740698801120743, 0.02061513137809622, 0.03122005028727775, 0.03288116305911293, 0.05829826475741962, 0.04586904909073686, 0.02972010402396942, 0.06109005921054631, 0.050331441029363, 0.01939305951430773, 0.024408229428033033, 0.014363946661857578, 0.016812595627270638, 0.024791643647477032, 0.009192478311403345, 0.007853535210015252, 0.006454837538961631, 0.0060840377005903674, 0.006640857946282873, 0.005544688185327686, 0.004924780289681318, 0.004337946722710815, 0.004207502713931414, 0.0038416774348782688, 0.06518662821423883, 0.03542971734500801, 0.027097755095455797, 0.0246808383493529, 0.03719211653806269, 0.022132878814203043, 0.07564726787153632, 0.029165161356407527, 0.11395992127712816, 0.06626697383044909, 0.11367907677001009, 0.08190159610395009, 0.02363800972001627, 0.03667715676982577, 0.03884624302852899, 0.040343732623538624, 0.029922191177029163, 0.01571981379839902, 0.16009790492864948, 0.011137446589806739, 0.022465507743957763, 0.01338318742501239, 0.01918215275160037, 0.02262458515644539, 0.028587763969165583, 0.021663240074412896, 0.049937044489973534, 0.017023473957475894, 0.013264885283618544, 0.025741798094629, 0.04423793206573464, 0.021794949280059275, 0.03495958042641481, 0.06315512761085605, 0.037871157582849264, 0.01322550260849918, 0.009473421176080592, 0.01615548229465882, 0.02896215010085143, 0.017238242067202616, 0.04576978234224953, 0.018321015986536317, 0.009903970191565652, 0.06305129217837627, 0.02382876125824017, 0.026378499956723922, 0.013955082288205934, 0.44263329981515803, 0.0506968495073185, 0.012140306812361813, 0.020964621075060374, 0.011486742040530467, 0.060983093103471525, 0.021544691965100355, 0.05783556249924004, 0.015402613527063902, 0.013850400624602723, 0.021389621869893745, 0.03211276891156255, 0.05924452363785046, 0.13045470164933554, 0.0115509495496129, 0.07079680592132111, 0.10378329913364723, 0.18699392369948328, 0.432212868022422, 0.013887166067045958, 0.014550747006336072, 0.11841614457545802, 0.021976671139127574, 0.03721212248240287, 0.022515581110492348, 0.03407864108526459, 0.013454880941232357, 0.4753218900505453, 0.04338947810969936, 0.08104078223618369, 0.03913545081353125, 0.06384907721308991, 0.023478318325360306, 0.005757851925397214, 0.012592715199862142, 0.008891698632311696, 0.006041240825579735, 0.002461340904216437, 0.0018059245916083454, 0.0015840371638478246, 0.0014711485642086093, 0.0013664435887039872, 0.0012676865682927504, 0.0011295067779428791, 0.0012267417457769625, 0.0010151451732720793, 0.0009547383147582877, 0.000929129068220694, 0.0008884795114863664, 0.0008522934616727677, 0.0008308266431170826, 0.0008089257523655154, 0.0007870129514534104, 0.0007694419286417543, 0.0007525192163545095, 0.000744373732037881, 0.0007499722165084676, 0.0007106504966698897, 0.0006963383406158149, 0.0006851961454958655, 0.0006722231903768261, 0.0006615143370921336, 0.0006517122630369461, 0.0006411409408125716, 0.0006316280272100509, 0.0006215361595604918, 0.0006126738467719405, 0.0006043567497787687, 0.000596866239720839, 0.0005882684479244441, 0.000581691296029021, 0.0005749913519442392, 0.0005671887075125899, 0.0005599994631362885, 0.0005548720472021766, 0.0005482479868563436, 0.0005413598449983207, 0.0005356464855018809, 0.0005302288574845685, 0.0005257427361963588, 0.0005192699332595415, 0.0005123198375440552, 0.0005073758212650622, 0.0005021585969613322, 0.0004972158213665049, 0.0004920098852502027, 0.00048760292509541614, 0.00048408308840104533, 0.0004789495271688793, 0.00047522741676705966, 0.00047024513291641295, 0.0004655002374905356, 0.00046113051031473635, 0.0004579016763091204, 0.0004531503987527685, 0.00044957967214334833, 0.00044544934695295524, 0.00044263081725754696, 0.0004383877692210566, 0.00043465982791531134, 0.00043202674820349787, 0.00042855832657854383, 0.0004242711635318604, 0.0004208901468033825, 0.0004190627479571655, 0.0004146859767085213, 0.00041178307075824706, 0.00040865632404650873, 0.0004053604531812501, 0.00040294783475474104, 0.0003996113640641852, 0.00039674225543421924, 0.00039371048313720773, 0.000390899724297924, 0.00038854053355559396, 0.00038568715335713933, 0.0003828884153214555, 0.00038022961366853753, 0.00037834909213415815, 0.00037533423371617874, 0.00037322680522872056, 0.00037045909717562606, 0.0003680040721519617, 0.0003659761935826585, 0.00036310969708817236, 0.0003617562166255084, 0.00035950287428325586, 0.00035717863834482463, 0.00035407347380290354, 0.00035229639021660354, 0.000349998856648502, 0.000348075053334469, 0.00034565454967378173, 0.0003437625387778098, 0.00034171183290406285, 0.0003397220197985007, 0.000337731478830392, 0.0003356342036446828, 0.0003340205151107511, 0.0003319786505198863, 0.00033032670284834846, 0.0003283922230184544, 0.0003266516020691294, 0.0003246096849943569, 0.00032293900278697644, 0.00032099986397952305, 0.00031944122381294925, 0.0003175998411825276, 0.00031582095747580754, 0.000314334629389729, 0.00031256906199511527, 0.0003109289497054609, 0.00030950552332797087, 0.00030834393349929694, 0.0003061718768609959, 0.00030464472558378475, 0.0003031086005527565, 0.0003021004870364171, 0.0003000961780586901, 0.00029872609101706376, 0.00029746665569594673, 0.0002957837618790412, 0.00029422618968358923, 0.0002932439541837084, 0.0002914281646614351, 0.0002901087317695783, 0.00028870238860690734, 0.0002872862162985257, 0.0002859815053579951, 0.0002845664017331728, 0.00028345359068528825, 0.00028206148232735965, 0.0002808961473783711, 0.00027942731495689564, 0.0002781647656593122, 0.0002770485797009314, 0.0002756074866798978, 0.000274480243964111, 0.00027329069012921537, 0.00027201295024648666, 0.00027090312791794226, 0.00026950261106321703, 0.00026863577693196324, 0.0002675844339986118, 0.0002663522520257781, 0.00026518437248038634, 0.00026384315500763475, 0.00026269645430147646, 0.0002616877739274059, 0.00026050808028230674, 0.00025947751323959284, 0.000258391412741427, 0.0002573665399359015, 0.0002562392110970298, 0.0002554432180719838, 0.00025431261889025336, 0.0002531575705567472, 0.0002523031055352476, 0.0002510956391051877, 0.00025013744832904196, 0.00024908498330357057, 0.000248119900503904, 0.00024712929915343316, 0.0002463538509437058, 0.0002452016863450505, 0.0002442985619381943, 0.00024367007719471682, 0.00024248414197548603, 0.0002415641624611453, 0.0002405850949071464, 0.00023966860114038962, 0.00023873540239947034, 0.0002378626400180413, 0.0002370265572850864, 0.0002360862746051377, 0.00023537837108354628, 0.0002343296983235632, 0.0002334649523436383, 0.00023269123376546002, 0.00023182605397475224, 0.0002309582903823563, 0.00023008332652049528, 0.0002291990938950524, 0.00022842218978742798, 0.00022770366648425504, 0.00022690007146593415, 0.00022606639041138502, 0.00022516770410826818, 0.00022443638890157065, 0.00022363241085865109, 0.0002228222669570338, 0.00022224782844811367, 0.00022131623435294994, 0.00022054037357520427, 0.00021985063069223542, 0.00021907123995940008, 0.0002183751272665783, 0.00021758172765961112, 0.00021686700016895581, 0.00021617814815423723, 0.00021536861495405902, 0.00021496286670905345, 0.00021398104698770718, 0.00021319445961125893, 0.0002124910688386687, 0.0002118897449963697, 0.00021112361096735791]
SGD30TrainLosses = [0.5313629761338234, 0.4258576912432909, 0.3853862437605858, 0.360263619273901, 0.3413692808151245, 0.32674868434667587, 0.31405091010034086, 0.3049164398511251, 0.2939602871984243, 0.2890169978886843, 0.2840725244830052, 0.27549381136894224, 0.2721483158568541, 0.26544500661393006, 0.25970767008761564, 0.2620746439198653, 0.2569682477166255, 0.2505395452057322, 0.2525555301209291, 0.24564586301644642, 0.24208482244362434, 0.23755915341277917, 0.23813856307417156, 0.23949244622141122, 0.23160583363225062, 0.22766836650669575, 0.22635549436012903, 0.2218025724714001, 0.2230198429400722, 0.2228410454466939, 0.21667915236204863, 0.21834121824552616, 0.21451740492135285, 0.20912973061203957, 0.20985737826675177, 0.2073748437066873, 0.20497709628194571, 0.20296780165284872, 0.19967280684659877, 0.2023491752271851, 0.1969082024693489, 0.1955947294458747, 0.19401087711254755, 0.19387576318035524, 0.19075868805249532, 0.19097954961160818, 0.18813811924308538, 0.18721499829242627, 0.19174979404856762, 0.18209731663266818, 0.18422880892952284, 0.1819728993376096, 0.1790353531142076, 0.17906762211273114, 0.17853606419016918, 0.17621251720935105, 0.17313947572062413, 0.1759123806282878, 0.17472515287498633, 0.17848409976810217, 0.16834133579706154, 0.17512834840764602, 0.1678757369890809, 0.16449998228500287, 0.16512949377298355, 0.16624873510251442, 0.16094937982658544, 0.16022385591020186, 0.1573975345492363, 0.15501087663695215, 0.15482930421829225, 0.15303272782514493, 0.1561670811784764, 0.15585519975051285, 0.14782277022798856, 0.16312421904255947, 0.14705104844023784, 0.14584099967653552, 0.14443819712226588, 0.14789371085042755, 0.14680615711957215, 0.14435340674594044, 0.14168474777291218, 0.13648373334979017, 0.13739187819262347, 0.13688243769109248, 0.13901117423549295, 0.13292819958801072, 0.13801089709003767, 0.12952309098094703, 0.12768932178616524, 0.13569049598028263, 0.12867519534503422, 0.12523933990548056, 0.12336639293779929, 0.12313267615313331, 0.1224540811466674, 0.12179905340696374, 0.11839059669524431, 0.11866125434016188, 0.11702509596322974, 0.1174747641881307, 0.11373127721250058, 0.1122068086390694, 0.1093928854415814, 0.11058346438532074, 0.11042208267996709, 0.1109841561007003, 0.10784145610406995, 0.10498684844623009, 0.10497766925642887, 0.10438963119561473, 0.1018083567544818, 0.10520841068277756, 0.10281716462224721, 0.09708304899434249, 0.09721728639677167, 0.09829881411666672, 0.09913489170993368, 0.09196400523806612, 0.09159207270480692, 0.08733353054150939, 0.08979011827458938, 0.09001774383708834, 0.08414541201976439, 0.08482386268054445, 0.08029566189895074, 0.08176098857385417, 0.07887536304692427, 0.08562097211678822, 0.08263726685817042, 0.07398833660098414, 0.07530242611654103, 0.07267046164721251, 0.0732276564805458, 0.06832257880829275, 0.0699398223714282, 0.06791640917770564, 0.06640015680963794, 0.06798062610439956, 0.07551795803941787, 0.06689333462777237, 0.06071978960496684, 0.08872972113390763, 0.06155387879349292, 0.06820963455053668, 0.05790602009433011, 0.057617683832844095, 0.05470966697360079, 0.053766145870710415, 0.05926094445710381, 0.0509307478973642, 0.05567800154909491, 0.04703766179891924, 0.04470634678689142, 0.04763187743412951, 0.0447400631584848, 0.0520803908413897, 0.042448630311215915, 0.04593788827924679, 0.052581980338630575, 0.042921116142533716, 0.04327122477038453, 0.03990943409192065, 0.15858869661887487, 0.03987840781919658, 0.04169024232309312, 0.03524402048594008, 0.06518172993790358, 0.07976804391946643, 0.052736570267006753, 0.05929109296916674, 0.07797536551797142, 0.031108045423558602, 0.031818070509471, 0.03089236899667109, 0.06712881443245958, 0.029011977734820296, 0.054806015946281456, 0.027164906084071846, 0.03435532718896866, 0.10195733770728112, 0.037817057863188286, 0.03435521744967749, 0.029092090939326833, 0.025667315697452675, 0.04642582626780495, 0.037684488353940344, 0.02713618555959935, 0.04093522062214712, 0.031733430550278476, 0.022571395439251015, 0.037417086561520894, 0.061460810565234475, 0.04748952060860271, 0.056509132261077566, 0.031164883779517063, 0.022202837735724946, 0.10213791476252178, 0.2524549036985263, 0.09889683565745751, 0.05263401681712518, 0.056515034879557786, 0.04402281573119884, 0.020703912038200847, 0.04326543643915405, 0.023483125048999985, 0.08972380109053726, 0.21073412140831352, 0.03110429023547719, 0.04479934893781319, 0.024089506749296562, 0.44239123055090507, 0.02582633715084133, 0.025174929739829773, 0.02427114674123004, 0.01873476243345067, 0.08055726930887128, 0.040498344206716864, 0.02890746951956923, 0.025236058981002618, 0.02814355696318671, 0.045736276044820744, 0.03667544561205432, 0.01842228679646117, 0.01899499014058771, 0.04545192252844572, 0.03418080154107884, 0.020598306906564782, 0.1409493981084476, 0.021546400313964112, 0.03546159620746039, 0.06888943316337343, 0.042701842546618234, 0.025633970768734193, 0.07589647647148619, 0.047285776501521465, 0.04105968183915441, 0.029440615366135413, 0.019942253663515052, 0.022115282921974237, 0.019146940720966087, 0.022276728512952104, 0.04014958742811965, 0.02642983372497838, 0.042757499320044495, 0.0810423795436509, 0.017516424383114404, 0.08588995866089438, 0.021098148064532626, 0.02517344698503924, 0.03814413883374072, 0.01644022982645159, 0.014842226014200908, 0.12550219982862473, 0.020431867962470276, 0.0342933018412441, 0.29066462340454263, 0.023459894625120797, 0.021817143462249076, 0.06782048943918198, 0.18124120691635956, 0.05229941160456898, 0.05220588001577804, 0.024907379005259522, 0.2729105427116156, 0.01746574501332361, 0.0622044645032535, 0.014147811172879301, 0.04136316684462751, 0.017871824413499174, 0.02688520521235963, 0.07554450925439596, 0.2059002241399139, 0.019008003341344497, 0.09932419350137935, 0.0345749373609821, 0.025810063731235764, 0.017678834103474705, 0.018115876217683156, 0.02834225446645481, 0.0437536593421828, 0.03741566391972204, 0.023932771974165615, 0.015328667722642422, 0.022109473649567613, 0.0233953418994012, 0.0309635257270808, 0.15628123697979995, 0.9973465537031492, 0.0574515141818362, 0.02759970470253999, 0.032158603849238715, 0.021552965225127993, 0.041392588682162265, 0.013568181059284446, 0.03100503419758752, 0.03289786293151944, 0.1292724406470855, 0.013423116053648603, 0.013064463313979407, 0.012459706861409358, 0.016510836821398697, 0.20404114964418113, 0.2710170176376899, 0.03212625105050392, 0.030030856601855095, 0.018467485088234148, 0.02644666737372366, 0.060461568812218806, 0.013837907074970039, 0.01726109448131562, 0.09282018814856807, 0.019109716272893516, 0.014922254618819958, 0.022207578987969708, 0.024432127350009977, 0.01476798103908853, 0.013069361368058405, 0.029063716818151685, 0.07674562682358858, 0.1901490482222289, 0.04219808497272121, 0.036834207169013096, 0.019257225594871367, 0.02508321528507319, 0.03690498534881044, 0.11699009713095923, 0.018935608111399535, 0.014237217595994783, 0.034057399281688654, 0.029728902773737596, 0.07088070841312098, 0.0137717788622831, 0.01959898497676477, 0.01713105333619751, 0.01601231007351695, 0.4844913259645303, 0.17558679069858044, 0.021958900667377747, 0.015438642499114696, 0.03728673899197019, 0.031256115232633115, 0.040246931264991875, 0.015617690630024298, 0.01824850933791216, 0.01348619554832112, 0.02076981024059933, 0.021503460983706948, 0.023288232612540014, 0.16912902220152318, 0.19874446777626872, 0.03489294292153015, 0.17824263916661343, 0.08431743196755027, 0.03553445184021257, 0.023408933289077442, 0.014755122053708571, 0.28957189606813094, 0.5812972313041488, 0.026702545826022592, 0.04361045096147185, 0.03658292197966754, 0.0260421199578559, 0.02153724688309012, 0.056315453930292275, 0.01859411624900531, 0.019839284571644383, 0.01895389997633174, 0.2763632234962036, 0.023416264582774602, 0.07188804494527479, 0.015203365411871346, 0.014979502699910274, 0.030544996147897716, 0.016207246758955685, 0.06736887394993876, 0.025444778995685435, 0.026642335589664678, 0.04174045747340036, 0.023310749855882024, 0.31730927812866866, 0.0938672144105658, 0.06348966114397626, 0.15464703006669878, 0.03572414151354072, 0.05290801493218169, 0.03837524512743888, 0.3448295298218727, 0.08271249665413052, 0.03119602456097103, 0.027919991202264405, 0.061890995058929546, 0.014755190704502942, 0.5515937694286307, 0.05723157004220411, 0.2814702844806016, 2.198656674027443, 0.22502064264069002, 0.03755402363177079, 0.024735516277141868, 0.034702211275386315, 0.07599492617727567, 0.03418898967152927, 0.03582362617579444, 0.01922695318547388, 0.07281944076220194, 0.011240471367297384, 0.010653302225788745, 0.010593258825150163, 0.01795922880099776, 0.012422251138583912, 0.007858353524255412, 0.01124942936381558, 0.013276871438817277, 0.012158476698580974, 0.03294778395191922, 0.04631513870243604, 0.022263117660283268, 0.6015275201201439, 0.01598477439363099, 0.017383766283164733, 0.015199789279140532, 0.015721746128450224, 0.009858801868200923, 0.036908030935398226, 0.005431543838009627, 0.002864892462142355, 0.002397016284618682, 0.002082922406564952, 0.001872257963065446, 0.0019792326613969637, 0.0015824158584655378, 0.0014416295661067125, 0.0014137352329028849, 0.0012280930401660348, 0.0012446120730601252, 0.0010382719662447926, 0.0010080262392633207, 0.0009116298297400741, 0.0008687076215088988, 0.0008411672504250115, 0.0008108731181588762, 0.0007829832678544335, 0.0007640397708989136, 0.0007415436142643254, 0.0007240338296711949, 0.0007084018914186648, 0.0006926991055055016, 0.0006779799342499852, 0.0006649423374377269, 0.000651467829241786, 0.000642073205071938, 0.0006313616835783856, 0.0006185856239729522, 0.0006077062573118989, 0.0005997447629852104, 0.0005875444784093513, 0.0005790989439022572, 0.0005716413027403177, 0.0005629233631771058, 0.0005545214043619733, 0.0005474714856791252, 0.0005395891021422964, 0.0005324606352648212, 0.0005257327407889534, 0.0005186286084669215, 0.0005121839466422292, 0.0005064559437475206, 0.000499465615181786, 0.0004936858559570586, 0.0004891842604896131, 0.000482590881450354, 0.00047784018113209944, 0.0004720540753927101, 0.0004661325280054977, 0.00046154599212362273, 0.00045759936240453194, 0.00045192236163226575, 0.00044735271327832983, 0.0004438672065953142, 0.0004388128729563808, 0.0004347390895782155, 0.0004304036040139181, 0.00042668102743239917, 0.00042265314171042214, 0.00041862231455525034, 0.00041481399969901155, 0.00041086651758329634, 0.00040743080838486395, 0.00040415495163567054, 0.0004001201066421345, 0.00039697341945914863, 0.0003934314500171846, 0.0003902184234842328, 0.0003869418810851736, 0.0003842905001450466, 0.0003805881323023641, 0.00037769069148149963, 0.0003746754752501147]
SGD40TrainLosses = [0.6003177092969417, 0.44308087065815926, 0.39445704460144043, 0.3634717216839393, 0.3446753866225481, 0.32842161079247795, 0.3153231749931971, 0.30637352354824543, 0.2965760372330745, 0.29145874207218486, 0.28697869926691055, 0.27977176333467163, 0.2762906172623237, 0.2696604653696219, 0.2641112997755408, 0.2670655142267545, 0.26247389120360215, 0.2547036280607184, 0.25601354071249566, 0.2506291427711646, 0.24758436946819226, 0.24227573278049627, 0.24291164031873147, 0.2419410372277101, 0.23711548693478107, 0.23412833319356044, 0.23273442337910336, 0.22795186864833036, 0.2287404177710414, 0.2316923187673092, 0.22361851307253042, 0.2239704196403424, 0.22502906480183205, 0.21648708153516055, 0.2170844691991806, 0.21542766553660234, 0.21273024614900352, 0.20997207834074894, 0.20705752387642862, 0.20837004972000917, 0.20479936466862758, 0.20462942197918893, 0.20226945317039888, 0.20187885063389938, 0.19943851143121719, 0.19807436964164177, 0.19792912200093268, 0.19615308232605458, 0.19920458557705084, 0.19197408051540454, 0.19174768384546043, 0.19086574636399745, 0.1878508633747697, 0.18794158216565848, 0.18747519481927155, 0.18635420851409434, 0.1834457243233919, 0.18419163482884565, 0.18544723942875863, 0.18517507065708438, 0.1810534927373131, 0.18511978220194578, 0.17722105933974186, 0.17619072654594978, 0.17663380060344935, 0.17631723816196124, 0.1721350256105264, 0.17139175097147624, 0.16875245135277508, 0.16605470575392245, 0.16661369925985733, 0.16596100946888329, 0.16878123157968125, 0.16689213670790196, 0.1599770962446928, 0.17105734662463268, 0.1599424344052871, 0.1597351565398276, 0.1564615033318599, 0.16283513446028033, 0.1571353264898062, 0.15526034869253635, 0.15606221242497365, 0.1506635775292913, 0.15060525325437388, 0.14972987102965513, 0.15083610162138938, 0.14641440176715453, 0.14570700177301962, 0.14549204545716446, 0.14153863285978635, 0.14396181975801786, 0.14062864627068242, 0.1388821237658461, 0.1379102688158552, 0.13619204850246508, 0.13598512527843318, 0.13562832575291395, 0.13316657188658912, 0.13283104807759324, 0.13202314934382836, 0.13573833829412857, 0.12984042055904865, 0.1278282535014053, 0.126332556878527, 0.12511417652790746, 0.12410872729495168, 0.12554270178700486, 0.1220642880971233, 0.12127287970855832, 0.12166809970512986, 0.12066738344108065, 0.11973644930248459, 0.12028055396551887, 0.11953637940809131, 0.11575575943415363, 0.1157014119438827, 0.12024140758439898, 0.11519517675042153, 0.10896819182982047, 0.11032582122832536, 0.10591818433254957, 0.10403949634482464, 0.10892355945582191, 0.10288741305470467, 0.1049910606071353, 0.09897326659411192, 0.09957671360423168, 0.09722967292492589, 0.09953978829085827, 0.10419618808974822, 0.09265217456345756, 0.10130309861153364, 0.09367549499496818, 0.09137115693651139, 0.08763871547455589, 0.08881746660297116, 0.08744326773410042, 0.09320224811012547, 0.08399550380185246, 0.08299953209857146, 0.08229679938095312, 0.08237185085502764, 0.09306063011288643, 0.08141787301438551, 0.08794912942685187, 0.07858511816089352, 0.07290041423402727, 0.07033599025259415, 0.0760727752186358, 0.07134769215248525, 0.06741234043613076, 0.06724789922125637, 0.07068295280138652, 0.06430715166032314, 0.06193599454437693, 0.06183443971909583, 0.06822802449886997, 0.06412062534751992, 0.059151212265715, 0.06197453045286238, 0.06449993196253975, 0.058502899420758085, 0.055654719692344465, 0.06706401018115381, 0.050708858963722986, 0.053058542717869084, 0.05045193251843254, 0.08403950937402745, 0.06888782068155706, 0.04910918751265854, 0.05152552957646549, 0.04278483354486525, 0.04022863608008871, 0.0425418215446795, 0.04063389826954032, 0.048240332606559, 0.04143248733133078, 0.03929767455983286, 0.03586938554886729, 0.036517693803956114, 0.033643167357270916, 0.03138413440901786, 0.03484214986674487, 0.03479781008791179, 0.032954492854575315, 0.05112462734337896, 0.03388390101492405, 0.033305568994643785, 0.03717941190116107, 0.0414467324083671, 0.045373786563674606, 0.052649230384267866, 0.029446155639210096, 0.05805493256465222, 0.028882057471976925, 0.041777917106325425, 0.028160493990095955, 0.048349079204102356, 0.10928725887245189, 0.04816536196197073, 0.030182915517749886, 0.035700763349886984, 0.036095673047627015, 0.02796866859930257, 0.05961928233969957, 0.03239843254520868, 0.10859195680978398, 0.02270144767477177, 0.05057383551184709, 0.019358905508803825, 0.05679199039470404, 0.03674733047800449, 0.033608363235058884, 0.03208326605536665, 0.11862986580468714, 0.15280882587035496, 0.4309395405650139, 0.03080737161139647, 0.027999560359554986, 0.024459374465513974, 0.026622010113205762, 0.024018116055522114, 0.017608078185391302, 0.022410375060280784, 0.023262233246156637, 0.020529420520567023, 0.020400121353256206, 0.016771200988053656, 0.011573403116781265, 0.009802683423040436, 0.008478786626365037, 0.012544422957968588, 0.007990202241344377, 0.006604066405949804, 0.00734562701099397, 0.0660843562381342, 0.03474243201393013, 0.3061647929623723, 0.027970654127032805, 0.10064563045433413, 0.04537461517844349, 0.024642893038302038, 0.030554496441812566, 0.031217596631807586, 0.07280156887602061, 0.2583867140052219, 0.037287224742273486, 0.05869191383011639, 0.02089801451501747, 0.028082575136601614, 0.1383952383014063, 0.02204219926847145, 0.023716756341746078, 0.06505756737470317, 0.02317284290601189, 0.4950627958153685, 0.03180401924764738, 0.027742895789366836, 0.018970921302291874, 0.03410125142429024, 0.02509348067493799, 0.01882812031544745, 0.020038841523346493, 0.053341653525518874, 0.05083997499197721, 0.02002964853697146, 0.03613331022051473, 0.019237911005038768, 0.06861530859644215, 0.01895035007968545, 0.043048525432047124, 0.020783671416187036, 0.02432491266285069, 0.023138933898493027, 0.01875571859854972, 0.01704591968950505, 0.027217205800310087, 0.03502419103014593, 0.14659685597444574, 0.0768356253936266, 0.039940476424526423, 0.027842447667693098, 0.02268078352208249, 0.013643870577022123, 0.01663344166028158, 0.023586966566120585, 0.025825486339163036, 0.019618376375874505, 0.039290761738084254, 0.019445167758191627, 0.14532235518718759, 0.023878566028239828, 0.031745189973153176, 0.030646825330137895, 0.016973681903327816, 0.16309546460397542, 0.02355950266161623, 0.03016038016998209, 0.1557154272403568, 0.03146242347856363, 0.09657082465787728, 0.044707222471867376, 0.024240774736972524, 0.022817177405231634, 0.02913636591557103, 0.013375280795929333, 0.010099324283849758, 0.013998895916932572, 0.07516455649223644, 0.008372374748966346, 0.006082970039036202, 0.008282142168609426, 0.005966486986241458, 0.004330076340847882, 0.0035861662422151616, 0.0033756348156991104, 0.0030424925615564766, 0.0027224228144526325, 0.002476693937254216, 0.0023311990357130223, 0.0022001434954048212, 0.002003345089008993, 0.0019255815827151916, 0.0018104951810285759, 0.0016531090482506746, 0.0015628370797882477, 0.0015365474562956175, 0.0014100259731397577, 0.0013911646773825245, 0.0012726567485757793, 0.0011966155385501527, 0.0011682609341611776, 0.0011184124083956704, 0.0010791156987155167, 0.0010446872489410452, 0.0010292531221542352, 0.0009995862276021702, 0.0009751186022185721, 0.0009556868350773584, 0.0009385364774304131, 0.0009200746303395136, 0.0009055895349592901, 0.0008850460126268445, 0.000867528853220089, 0.000856474739581851, 0.0008439464906405191, 0.0008259051861144448, 0.0008172277012878719, 0.0008005347426539326, 0.0007883510162840442, 0.00077794857272238, 0.0007665841514972271, 0.0007564872142393142, 0.0007460316021752078, 0.0007351353026266831, 0.0007250107678798182, 0.0007160551140016954, 0.0007073871882676031, 0.000699753047908113, 0.0006915990711786435, 0.0006819009661800616, 0.0006740331797179048, 0.0006667187810671749, 0.0006583658625459066, 0.0006500754787217981, 0.0006426025093484593, 0.000635692333028904, 0.0006282599134768437, 0.0006230772156413878, 0.00061622542712333, 0.0006102913243861015, 0.0006043240036403101, 0.0005975754388055066, 0.0005930637228326911, 0.0005867200456365632, 0.0005811210139897108, 0.0005759825621983812, 0.0005705463645184258, 0.0005644715553353308, 0.0005596884895324668, 0.0005542519619969728, 0.0005486175350961275, 0.000544063980220623, 0.0005395920722245743, 0.0005348237484577112, 0.0005292390786780743, 0.0005250056531197818, 0.0005203430825592174, 0.000516706688965011, 0.0005125322676637248, 0.0005087633769653621, 0.0005042870119117046, 0.0004997518374875654, 0.0004981083786818393, 0.0004934569202062752, 0.0004882153417080796, 0.0004841455158384633, 0.00048057588928107484, 0.0004768754487061718, 0.0004731680638845622, 0.00046976899064854173, 0.0004665679168162266, 0.00046296327859939387, 0.00046005628418546013, 0.00045658306748615966, 0.0004547515756227464, 0.00045068632477826516, 0.00044738314109660373, 0.0004442773195478367, 0.00044077386577555443, 0.00043877706719892254, 0.0004361157054275585, 0.0004321672306408194, 0.0004293987977265109, 0.00042650553745867607, 0.00042411809089874927, 0.0004215557724334455, 0.0004186071267213265, 0.0004158932774225832, 0.00041414496625899726, 0.000411264769063564, 0.0004081119200903534, 0.00040554902887379285, 0.0004029133504203249, 0.00040094585027569945, 0.0003982892543960285, 0.0003961757016683502, 0.00039374377694912255, 0.0003913719710908481, 0.0003890570832178734, 0.00038669144186011787, 0.00038510815822519363, 0.00038220752613900305, 0.0003799877443088917, 0.00037819713950739244, 0.00037575378627176785, 0.0003740506649410236, 0.0003720231850699444, 0.0003695116546320302, 0.00036733260208469194, 0.0003660198074309543, 0.0003637587851456677, 0.00036143719766793464, 0.0003598799623432569, 0.0003579794700878362, 0.0003558283338255327, 0.0003541526297825233, 0.00035225842644649675, 0.00035023842747250455, 0.00034859116603911386, 0.0003467240102327196, 0.0003449294900262127, 0.0003433366806348204, 0.0003415842994278743, 0.00033986970943563694, 0.00033829370954966483, 0.0003364875321737297, 0.0003347574383345394, 0.0003334959528729087, 0.0003314864175505742, 0.00032995313884991146, 0.00032846993148875, 0.0003267764299804791, 0.0003252965493205314, 0.00032386690071992537, 0.0003221432694529843, 0.0003207233617649763, 0.0003191382420967178, 0.0003177660823591092, 0.000316143058923141, 0.00031525200753094394, 0.00031330343448037943, 0.0003122369503519925, 0.00031049012519360984, 0.0003090157224687573, 0.00030770081575610676, 0.00030637355841463433, 0.00030490730377399206, 0.00030364188528134644, 0.00030290094640804453, 0.0003009022874539369, 0.0002997308172780322, 0.0002983324642627849, 0.0002970058618787637, 0.0002959123398856415, 0.00029458318946126385, 0.000293307222424725, 0.0002920215967787954, 0.00029092696064860016, 0.00028972530573810216, 0.0002884569899348814, 0.0002872969279026923, 0.0002860032950896615, 0.0002852830454624685, 0.00028380869485772564, 0.00028256186855893855, 0.00028148899773441374, 0.0002803424854573677, 0.00027931132849820034]
plt.plot(SGDTrainEpochs, SGDTrainLosses, color='b', label="SGD")
plt.plot(SGDTrainEpochs, SGD10TrainLosses, color='r', label="SGD10")
plt.plot(SGDTrainEpochs, SGD20TrainLosses, color='g', label="SGD20")
plt.plot(SGDTrainEpochs, SGD30TrainLosses, color='y', label="SGD30")
plt.plot(SGDTrainEpochs, SGD40TrainLosses, color='m', label="SGD40")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
plt.yscale('log')
plt.legend()
plt.title("Train Losses of SGD with Regularizations on FashionMNIST")
plt.xlabel("Epochs")
plt.ylabel("Train Loss")
plt.savefig("FashionMNISTSGDwRegTrainLosses")
plt.close()

SGDTestEpochs = np.arange(200)
SGD = [0.41627046406269075, 0.3645604021847248, 0.3479840523004532, 0.3297156916558743, 0.30261552676558495, 0.29979252472519874, 0.2776524828374386, 0.28400649830698965, 0.27362041510641577, 0.2636630187928677, 0.2648416158556938, 0.2656176909804344, 0.2746382840722799, 0.25437515929341314, 0.27875294484198093, 0.25736398972570895, 0.24325717493891716, 0.25314061909914015, 0.2558984550088644, 0.25423489086329937, 0.25047776475548744, 0.2677528192102909, 0.26823295183479784, 0.24870317682623863, 0.25264579746872184, 0.27942563336342574, 0.26603316850960257, 0.29044014975428584, 0.26416361883282663, 0.2588717099279165, 0.26487569496035573, 0.262788623124361, 0.28932056449353694, 0.2777794748544693, 0.2835186196863651, 0.27064308766275647, 0.2956281716376543, 0.29593416936695577, 0.2964160507172346, 0.2899383781850338, 0.3027061877399683, 0.3086820727586746, 0.29473999232053755, 0.3304901018738747, 0.31403361171483996, 0.3159969834238291, 0.3170883090049028, 0.3226972333341837, 0.34122568897902966, 0.339311862885952, 0.33733892858028414, 0.3757081564515829, 0.36111807882785796, 0.3668579511344433, 0.35708679124712944, 0.37501910082995893, 0.3710033993050456, 0.35496682099997995, 0.4345565351843834, 0.41587039329111575, 0.38720916796475646, 0.38808073833584783, 0.42884401127696037, 0.415848169028759, 0.41324515238404275, 0.41962690494954585, 0.4291847735643387, 0.4603657653927803, 0.4329187551140785, 0.4456804519239813, 0.43846723504364493, 0.4547178780287504, 0.4536623513698578, 0.4648969013243914, 0.5063553465157747, 0.46558239579200744, 0.5086620844900608, 0.49677149318158625, 0.4945405646413565, 0.49109254375100136, 0.5101718521118164, 0.5010158194229006, 0.5053202071785927, 0.5024667557328939, 0.5275922444462776, 0.5284816023707389, 0.5468972946703434, 0.5296002081781626, 0.5605819301307201, 0.5492233418673277, 0.5472584680467844, 0.5507021052390337, 0.5692148305475712, 0.5631797445565462, 0.5628061994165182, 0.5833971291780472, 0.5677379138022661, 0.5690640636533498, 0.5773482830822467, 0.5765344502776861, 0.5830081737041474, 0.5831509632617236, 0.5867278359830379, 0.58826151560992, 0.5896192537993192, 0.592320399582386, 0.596978709846735, 0.5971290183067322, 0.5982648958265782, 0.6055285497009755, 0.6059310904145241, 0.6051530953496694, 0.6080533739924431, 0.6106447187066079, 0.6129648905992507, 0.6148317128419876, 0.614351662248373, 0.6187735795229673, 0.6190171685814857, 0.6219871924817562, 0.6233576972410083, 0.6238230497390032, 0.6283473737537861, 0.6292812811955809, 0.6303071862459183, 0.632998316437006, 0.6332323298603296, 0.6331321546435356, 0.6387174735963345, 0.6409906396269798, 0.6388126859813928, 0.6413338260352611, 0.6439466163516044, 0.6458650319278241, 0.6461055559664964, 0.6468068296462297, 0.6494463074952364, 0.6515877664089202, 0.6522765243053437, 0.6546824088692665, 0.6559511321783066, 0.658355768173933, 0.6587918742001057, 0.6589437299221754, 0.6592075218260288, 0.6612779458612204, 0.6630794860422611, 0.6635334151983261, 0.6650189198553562, 0.6661506927013398, 0.6676130238175392, 0.6692081131786108, 0.67078214623034, 0.6725829336047172, 0.6714037315547466, 0.6735351940244436, 0.6746719266474247, 0.6779715330153704, 0.676410645544529, 0.6782059057056904, 0.6804950162768364, 0.682208171710372, 0.6826213544607163, 0.684134468883276, 0.6839393825829029, 0.6845918297767639, 0.6871452108025551, 0.6869921149313449, 0.6894711868464947, 0.6894393549859523, 0.6908119305223227, 0.6906501848250628, 0.6922593669593334, 0.6934080451726914, 0.6930459973961115, 0.6961049338430166, 0.6954484536498785, 0.6987585527449847, 0.6970546664297581, 0.7003269549459219, 0.7005262596905232, 0.7003414891660213, 0.7021520783752203, 0.7031674829125404, 0.7043327821046114, 0.7042253720760345, 0.7047606953233481, 0.7062027271091939, 0.7076254634559155, 0.7077161507308483, 0.7102038477361202, 0.7095359753072262, 0.7117821830511093, 0.71098497107625, 0.7125290477275849, 0.7130308162793517, 0.7152028059959412, 0.7144031995534896, 0.7157804007083177, 0.7151867397129535]
SGDwReg = [0.4320616263151169, 0.38928734213113786, 0.345763870626688, 0.32416227474808695, 0.3138918471336365, 0.30464773133397105, 0.2980816316604614, 0.2865898311138153, 0.2814726832509041, 0.2800713182985783, 0.2723648032546043, 0.26848296374082564, 0.2650050641596317, 0.265153521746397, 0.26175440222024915, 0.2614347906410694, 0.25757183983922005, 0.2530219101905823, 0.2502735668420792, 0.24883838430047034, 0.2456892006844282, 0.24662148103117942, 0.2500079663842916, 0.2469056886434555, 0.24115387007594108, 0.24378999650478364, 0.24486983694136144, 0.23791350468993186, 0.2371180084347725, 0.23589284151792525, 0.2376711716502905, 0.23590029567480086, 0.2373531174659729, 0.23240148827433585, 0.23387029357254505, 0.23379589281976224, 0.23272339932620525, 0.231610654219985, 0.23872420877218248, 0.2358987868577242, 0.23602393254637719, 0.22863255426287651, 0.2300906077027321, 0.23079746626317502, 0.23015531092882158, 0.23501102946698665, 0.2321807723492384, 0.2344194623082876, 0.2386600975692272, 0.2344821260869503, 0.23737310476601123, 0.23721635326743126, 0.23366224721074105, 0.23564167693257332, 0.24732422173023225, 0.2364889159053564, 0.23824892222881316, 0.24777213923633098, 0.240231254696846, 0.244426819011569, 0.24872346013784408, 0.2510573720186949, 0.2574877565354109, 0.2565092407166958, 0.25039116449654103, 0.2517286679893732, 0.25679025061428545, 0.2577701718360186, 0.275332068130374, 0.26220092169940473, 0.2688695108145475, 0.26382393658161163, 0.2683582743257284, 0.27666901022195817, 0.2791438913345337, 0.2924450616538525, 0.27883429259061815, 0.28275865882635115, 0.28283774316310883, 0.29184490218758585, 0.316955052241683, 0.29878353781998157, 0.30855691365897653, 0.3094857373088598, 0.33167943455278875, 0.3016867805272341, 0.3081891429424286, 0.3171831648051739, 0.3178602422401309, 0.3258018009364605, 0.3404948338866234, 0.33443240620195863, 0.32850498735904693, 0.3417083089053631, 0.34472499892115593, 0.34696960501372814, 0.3529215803742409, 0.34192197494208815, 0.3523388358205557, 0.3745529938489199, 0.36545438550412657, 0.36193921595811845, 0.3779992774128914, 0.38574187144637107, 0.36620634838938715, 0.38319197706878183, 0.38041197322309017, 0.38140403769910336, 0.3757178857922554, 0.3903517669439316, 0.3760364580154419, 0.37676401652395725, 0.4039802588522434, 0.3920886467397213, 0.4107030799984932, 0.4023087078332901, 0.4089594192802906, 0.39068492092192175, 0.39614899262785913, 0.40259466618299483, 0.528603863120079, 0.40899610698223116, 0.4115204805880785, 0.4146204982325435, 0.42004964970052244, 0.41341727554798124, 0.4350868261605501, 0.4127208898961544, 0.41463938519358634, 0.46394714415073396, 0.41965512573719027, 0.4301220282912254, 0.4289433334767818, 0.4368430945277214, 0.4347078922390938, 0.4522230844199657, 0.45573883384466174, 0.4426855991780758, 0.4287670678645372, 0.43553802572190764, 0.43708903528749943, 0.44242873959243295, 0.44847670160233977, 0.4545699970424175, 0.45409832570701836, 0.478352702409029, 0.44500358000397683, 0.4485452587902546, 0.4727307239174843, 0.4657264794409275, 0.461161721944809, 0.49554592549800874, 0.4765824877470732, 0.4801927964389324, 0.46696266874670983, 0.46062336042523383, 0.4530301947891712, 0.47777952641248705, 0.4853677536547184, 0.4965530426800251, 0.45842351466417314, 0.49637348592281344, 0.5004194104671478, 0.4909202274680138, 0.501020510494709, 0.48724466025829316, 0.5125497560203075, 0.49137275069952013, 0.4970801354944706, 0.5058405184745789, 0.5102347170561552, 0.48229793228209017, 0.49230074808001517, 0.5098186627030372, 0.508540708720684, 0.5349224434792995, 0.5067271154373885, 0.5030967459827661, 0.5170897920429707, 0.5257058095932007, 0.5143280617147684, 0.5580332039296627, 0.49934662878513336, 0.4926802534610033, 0.5387605503946543, 0.5361365333199501, 0.5330816558003426, 0.5220436055213213, 0.5166380052268505, 0.5465976336598396, 0.5531968831270934, 0.5189772316813469, 0.5217268227785826, 0.5712959609925747, 0.5337517954409122, 0.5376756794005633, 0.5238683877885342, 0.5516909764707089, 0.5160594321787357, 0.5110611198842525]
SGDNeg5 = [0.44867207437753676, 0.37314911872148515, 0.3637596100568771, 0.3414024218916893, 0.3178695414960384, 0.30432736247777936, 0.28774668589234353, 0.28136107698082924, 0.29065128341317176, 0.286925625950098, 0.2751059296727181, 0.273534619435668, 0.264598576053977, 0.26764855325222014, 0.2763860061019659, 0.25898738734424115, 0.2624053769558668, 0.2702998735755682, 0.2788072934746742, 0.2658666916936636, 0.2788883738219738, 0.2760138214379549, 0.24869703456759454, 0.26174321353435515, 0.2790413552522659, 0.26609312675893304, 0.2640223523229361, 0.26561974853277204, 0.2732052942365408, 0.2581927116215229, 0.27143471129238605, 0.25468314945697784, 0.25768143340945243, 0.26196600720286367, 0.2865578907728195, 0.27512549474835396, 0.2737371393293142, 0.3194789680838585, 0.2751642265170813, 0.2669860043376684, 0.2622340978309512, 0.25755935192108154, 0.27242411345243456, 0.2738521481305361, 0.3417936071753502, 0.28069937862455846, 0.2785842023789883, 0.28076922744512556, 0.27694536074995996, 0.30427597545087337, 0.30147657334804534, 0.2910262387245893, 0.29948357827961447, 0.282249396443367, 0.2882457069307566, 0.3135976293683052, 0.33206856101751325, 0.32069201067090036, 0.31014504671096804, 0.32060339719057085, 0.2967555371671915, 0.3313534332811832, 0.3390923646837473, 0.3345102472603321, 0.3275665909796953, 0.32717060461640357, 0.3393091107159853, 0.3389247741550207, 0.3293168889731169, 0.33582278542220595, 0.3598196779936552, 0.3448004677146673, 0.3590455511212349, 0.34404048152267935, 0.34362944394350053, 0.3780236828327179, 0.3674379197508097, 0.3985238172113895, 0.3568576876819134, 0.3647946733981371, 0.37750373475253585, 0.3821617938578129, 0.3803132572770119, 0.3740149509161711, 0.3976203214377165, 0.4180842112004757, 0.3855562837421894, 0.4080664251744747, 0.40390036687254904, 0.41837727293372157, 0.45417750358581543, 0.446904049962759, 0.43354346133768557, 0.4151187928393483, 0.4734259684383869, 0.4367581007629633, 0.4461342965438962, 0.44636203672736885, 0.4709554345905781, 0.4921152187883854, 0.47946067310869694, 0.4419297407567501, 0.4710292075574398, 0.5040994344651699, 0.4975064350664616, 0.4684539869427681, 0.46645731437951327, 0.4505705440044403, 0.45833897553384306, 0.4823348882421851, 0.4804028219729662, 0.5177765836566687, 0.5110025483369828, 0.4931358768045902, 0.48477723479270934, 0.5500189255177975, 0.5104089471697807, 0.5028535866737366, 0.5226874425262212, 0.5170055915415287, 0.5502020155265928, 0.552015056014061, 0.545235065817833, 0.5454331754148006, 0.5799976226687431, 0.5272350077703595, 0.5483337415754795, 0.5869665573537349, 0.5632233813405036, 0.5761528015136719, 0.5500648768246174, 0.5820406137406826, 0.5781158362329006, 0.5905960142612457, 0.5679536480456591, 0.6060535998642445, 0.5839377331733704, 0.5880678340792656, 0.5633725412935019, 0.5644935568422079, 0.6340845579653979, 0.5986520697176456, 0.624485887736082, 0.5956101728975773, 0.6306185781955719, 0.6007613386213779, 0.586950211673975, 0.6470086258649826, 0.6815330086648465, 0.6297834676504135, 0.7424833229184151, 0.6747244726121425, 0.6566804005205631, 0.6111589991301298, 0.7105875183641911, 0.684261969923973, 0.5934743759036064, 0.6587747667357325, 0.6356963348388672, 0.6334799545258284, 0.6620444011688232, 0.6703714281320572, 0.7006759316474199, 0.6830491307377815, 0.667312906384468, 0.7488246919214725, 0.6867294239997864, 0.6811677233874798, 0.6573061303794384, 0.675180682092905, 0.7630941520631314, 0.6601414401829243, 0.7486056376993656, 0.6938036024570465, 0.7491029024124145, 0.7017613876610994, 0.7070084048807621, 0.7582552938908339, 0.7645265297591686, 0.7601371210813522, 0.7267998805642129, 0.9545498864352703, 0.723975010663271, 0.75632936373353, 0.7324400024116039, 0.8788808284699917, 0.7323954985290766, 0.7835111460089683, 0.7769664658606052, 0.8356843519210816, 0.7644883467257023, 0.7970592711865901, 0.721409455537796, 0.7388478803634644, 0.8583040909469127, 0.7872125062346459, 0.8188046155869961, 0.8126146341860294, 0.7748351782560349, 0.7612304925918579]
SGDNeg3 = [0.4364870709180832, 0.3650087995827198, 0.3571865665912628, 0.32835176333785054, 0.3097877112030983, 0.2991156946122646, 0.28019787758588793, 0.2766947191208601, 0.29057393357157707, 0.2755752719938755, 0.2741033113002777, 0.26668588906526564, 0.2576592403650284, 0.26055126868188383, 0.2631938071548939, 0.25873572677373885, 0.25686385937035083, 0.2543088535219431, 0.27053682774305343, 0.2631437934935093, 0.2699652026593685, 0.27614800810813905, 0.2478541796654463, 0.25641126811504367, 0.2651349237561226, 0.27368991024792194, 0.2545329289883375, 0.2575376016646624, 0.2874846977740526, 0.26818046778440474, 0.26299903362989424, 0.25666975766420363, 0.26517022147774694, 0.2646413365751505, 0.28351216241717336, 0.29379155024886133, 0.28079078800976276, 0.2848632187396288, 0.2819888372719288, 0.2917997620999813, 0.28275621302425863, 0.2690162592381239, 0.29429066568613055, 0.292225326448679, 0.3324388091266155, 0.3289597371965647, 0.30091699451208115, 0.30222552463412283, 0.29490196891129017, 0.2964965921640396, 0.30740104921162126, 0.31935512490570545, 0.3479921966046095, 0.316039891988039, 0.3520850852131844, 0.3364046926796436, 0.32687811240553855, 0.36904213555157184, 0.3524203713238239, 0.34548036836087703, 0.3471440570056438, 0.360961440205574, 0.35764991737902163, 0.35471231512725354, 0.3663822036236525, 0.36460619829595087, 0.3744796015322208, 0.3742805802077055, 0.4005600124597549, 0.39116958290338516, 0.42092569693923, 0.39920062452554705, 0.4369627857208252, 0.4658280019462109, 0.4211885719746351, 0.41611147627234457, 0.4395405627042055, 0.4737101498246193, 0.4274471752345562, 0.434923727363348, 0.43953704722225667, 0.44662489160895347, 0.43653232797980307, 0.4410864494740963, 0.47625826217234135, 0.46638134613633153, 0.46949757397174835, 0.48750115871429445, 0.49528464436531067, 0.48091762475669386, 0.5464442762732505, 0.4993588573485613, 0.4896481980383396, 0.5059606399387121, 0.5124422618746758, 0.520691140294075, 0.504687360599637, 0.5332268080115319, 0.5198967530578374, 0.5410365004837513, 0.5457582619413733, 0.5236950581520796, 0.5559739276021719, 0.5370411671698093, 0.5753576311469079, 0.5948878900706768, 0.5728664807975292, 0.5903716243803501, 0.5553987501561641, 0.5857953845709563, 0.5958786576241255, 0.5849125585053117, 0.6306284072995186, 0.594701389670372, 0.5888211224973202, 0.5957498544454575, 0.6278381407354027, 0.6143726426362991, 0.6632020215690136, 0.6386613094806671, 0.6187333828955889, 0.6182328426837921, 0.6363983170688152, 0.692432569861412, 0.6601075547933578, 0.636249148696661, 0.6593877797946334, 0.6665054405853152, 0.6625219722092152, 0.689630081653595, 0.6865431772172451, 0.7321142268180847, 0.6490461459755897, 0.7046625658869743, 0.7156230063736438, 0.7018280451744795, 0.7187193414568901, 0.7234040731191635, 0.677827413007617, 0.7552949705719948, 0.7354959419369698, 0.6953524177521467, 0.7466471795737744, 0.7608295626938343, 0.726928394138813, 0.7390339210629463, 0.766567694246769, 0.7392513904720545, 0.836514707505703, 0.7649516636133193, 0.7735565303266049, 0.8285993672907352, 0.8185403168201446, 0.8081795425713062, 0.804576087296009, 0.7829774370789528, 0.7844256734848023, 0.8199691389501095, 0.8241357029974461, 0.8205879721790552, 0.8029217766225338, 0.832374780625105, 0.8275465090572834, 0.9163190229237079, 0.8454678599536419, 0.825124798156321, 0.9367122432589531, 0.8240671253949404, 0.9818228515982628, 0.8258722421526908, 0.8457199992239475, 0.9185380038619041, 0.8416303725540638, 0.817100005298853, 0.9248582200706005, 0.8664819315075875, 0.9290812854468823, 0.9201519146561623, 0.9051576761901379, 0.8869296577572823, 0.860589692518115, 0.8851491901278495, 0.9352273999154568, 0.8830636321008205, 0.8920469044148922, 0.932943562567234, 0.8962467733025551, 0.9218444392085076, 1.014681811928749, 0.9685301743447781, 0.9034629207849503, 0.9466754156351089, 0.9803639999032021, 0.9250721974670887, 1.0823211842775344, 0.9508758395910263, 0.991401904374361, 0.9457561358809471, 1.0301049181818962, 0.9820630010962487]
SGDNeg1 = [0.42729391232132913, 0.3590729342401028, 0.3523640277981758, 0.31958350956439974, 0.3006619609892368, 0.300185739248991, 0.2779546770453453, 0.2728179317712784, 0.29307640343904495, 0.26872722670435906, 0.26736648119986056, 0.2583634816110134, 0.25221971698105333, 0.2592500545084476, 0.2551288675516844, 0.2578816609084606, 0.2533548918366432, 0.24925778806209564, 0.26662530824542047, 0.26425932623445986, 0.2644662424176931, 0.2774431213736534, 0.24962559044361116, 0.25122174426913263, 0.25635968908667567, 0.27924402482807636, 0.265516519844532, 0.25831807613372804, 0.2816565096378326, 0.26845674455165863, 0.2720794228464365, 0.26156455390155314, 0.26891217797994615, 0.28052623093128204, 0.27962585605680945, 0.2934729835018516, 0.2862464253604412, 0.2948593807965517, 0.29304804399609563, 0.2948758381605148, 0.2871510403603315, 0.2943417627364397, 0.3113083701208234, 0.3227538473904133, 0.3223971153050661, 0.3221013520658016, 0.31760487280786037, 0.32671238988637924, 0.31868165239691737, 0.3369108210504055, 0.3678639106452465, 0.35242354333400727, 0.3570275864750147, 0.3421431439369917, 0.38016662806272505, 0.36354942448437216, 0.3514419125579298, 0.40889103785157205, 0.40860456623137, 0.40263472847640513, 0.379164035320282, 0.38699283450841904, 0.40014142319560053, 0.40773350492119786, 0.42181348115205763, 0.40555957935750486, 0.417825683131814, 0.42862751595675946, 0.42547421671450136, 0.4354050214588642, 0.4374272604286671, 0.4464186941087246, 0.5233138543367386, 0.4348687611706555, 0.4450833919644356, 0.48035422459244725, 0.4720354912430048, 0.4739731724560261, 0.4795161734521389, 0.4881760087609291, 0.513684414550662, 0.5054902070760727, 0.5090691225230694, 0.5135203839838505, 0.5082308408617974, 0.5354040895402431, 0.5632571877539158, 0.5381097055971622, 0.5471628403663635, 0.5439948973059654, 0.5702243741601706, 0.5498271229863166, 0.5713194823265075, 0.5711489982903004, 0.5791104525327683, 0.5773427765071392, 0.5700130487978459, 0.5974035967886447, 0.6068320743739605, 0.605189864486456, 0.6034947153180837, 0.605966679006815, 0.6128295892477036, 0.5891268995404243, 0.5954736436903477, 0.6003692547976971, 0.6061247944086791, 0.608930591493845, 0.6135171810537576, 0.6183196519315243, 0.6182441538572312, 0.6218211980164051, 0.6235625395178794, 0.625344902202487, 0.6251279162615537, 0.6305439078807831, 0.6309783161431551, 0.6357429981231689, 0.6367128698527813, 0.64227518863976, 0.6395831872522831, 0.6430559083819389, 0.6452829042077064, 0.6481966169178486, 0.6495383369922638, 0.648526661619544, 0.6512674898654223, 0.6550092288851738, 0.6544516162574291, 0.6566409434378148, 0.6580355996638536, 0.6600649522989989, 0.6609166542440653, 0.660605773916468, 0.6628348091244698, 0.665655598193407, 0.666326646655798, 0.6687682890146971, 0.6699989400804043, 0.6701487928628922, 0.6717922286689282, 0.6729163893312216, 0.6736130577325821, 0.6776887086033822, 0.6776378947496414, 0.6781140938401222, 0.6783326493948698, 0.6812488382682205, 0.6827646096795797, 0.6844199585914612, 0.6841388331353664, 0.6851086382567882, 0.6854692542552948, 0.6881418727338314, 0.6902404968440533, 0.6895180273056031, 0.6907732447981835, 0.693284922093153, 0.693962614685297, 0.6946673137694597, 0.6964965876936913, 0.6967984983325004, 0.6990639464557171, 0.6995462080091238, 0.6996079910919071, 0.701672111749649, 0.7015301917493343, 0.7031695513054729, 0.7059168149530888, 0.7040698549151421, 0.7065068788826465, 0.7077992595732212, 0.7082951433211565, 0.7083824230730533, 0.7104968345165252, 0.71107217669487, 0.7116449620574713, 0.71292455509305, 0.714579857364297, 0.7151453074812889, 0.7140851651132106, 0.7154552544653415, 0.7173783007264137, 0.7171620172262192, 0.7176708996295929, 0.7196292552351952, 0.7204363529384136, 0.7218269850313663, 0.7238703987002373, 0.7236516945064068, 0.7235090984404087, 0.7247341291606426, 0.7253065139055253, 0.7269576314091682, 0.72674132168293, 0.7270073115080595, 0.7287959808111191, 0.7291984105855227, 0.731564745604992, 0.7308028295636178]
SGDPos1 = [0.4209163923561573, 0.3612012013792992, 0.34646513402462004, 0.3149048148095608, 0.2947951029241085, 0.3046905329823494, 0.2759405948221684, 0.27208377003669737, 0.2888186360895634, 0.26535439379513265, 0.2777171191573143, 0.25460866808891297, 0.2504754428565502, 0.25612465120851996, 0.2550599607080221, 0.2518772669136524, 0.25187447033822535, 0.25321313366293907, 0.25426103226840496, 0.25847023494541643, 0.26354789271950724, 0.2762376770377159, 0.259462431371212, 0.2563055343180895, 0.26561444766819475, 0.3063782860338688, 0.27499703474342824, 0.2667756487429142, 0.3125408160686493, 0.2663124371320009, 0.29015351586043836, 0.2789581009745598, 0.2791218776255846, 0.2823719252645969, 0.2938023802638054, 0.2934346469119191, 0.30310433320701125, 0.32671686381101606, 0.30411341778934003, 0.3397650995850563, 0.31227292992174627, 0.3149589940160513, 0.34262539353221655, 0.343853727504611, 0.36208687610924245, 0.3608213059604168, 0.3502310112118721, 0.359760957211256, 0.34845666408538817, 0.3606961360573769, 0.3728488022834063, 0.4066071102768183, 0.4001827046275139, 0.3774301366508007, 0.4066724106669426, 0.39512787863612175, 0.38452943056821826, 0.41392659343779087, 0.4371313889324665, 0.42579107858240606, 0.43868943333625793, 0.4668289776146412, 0.43680160388350486, 0.44343382939696313, 0.4360582335293293, 0.4518504738807678, 0.45115578442811965, 0.4660906172543764, 0.48227949991822244, 0.4894975510239601, 0.48921101123094557, 0.4856976015120745, 0.49468993067741396, 0.4978269843198359, 0.5138647943362593, 0.5197472080588341, 0.5456864775717258, 0.527322822958231, 0.5309105019271374, 0.5328397472202778, 0.5315218023210764, 0.5570852056145668, 0.5605749459564686, 0.5535524164140224, 0.5629860196262598, 0.5706797496974468, 0.5616156892478466, 0.5681730423122644, 0.573680085092783, 0.5747887562215328, 0.5782030433416366, 0.5792181672155857, 0.5885569988936186, 0.5861511125415564, 0.5940834787487984, 0.5952690303325653, 0.5981557405740022, 0.6057022816687823, 0.6027050741016865, 0.6052515856921673, 0.6072172555327415, 0.6111781002581119, 0.6177785919606685, 0.6177131204679608, 0.6213905549049378, 0.6227379918843508, 0.6255302876979113, 0.6246244415268302, 0.6320192343741655, 0.6335071141272783, 0.633839956074953, 0.6353802497684956, 0.6379352062940598, 0.6374489979445934, 0.640770246386528, 0.645588877350092, 0.6472528725862503, 0.6488984228670597, 0.6518280294537544, 0.6547643923759461, 0.6548889176547528, 0.656960597038269, 0.6584097354114056, 0.6597481110692024, 0.6629798740148545, 0.6651843392848968, 0.665844223126769, 0.6696861642599106, 0.6679386861622334, 0.6718746235966683, 0.6725204522907734, 0.6738208246976137, 0.6752923311293125, 0.6765996550768614, 0.6787983842194081, 0.6812262207269668, 0.6814099957048892, 0.6826741252839565, 0.685303768068552, 0.6845575016736984, 0.6867259946465493, 0.6879179398715496, 0.6891306022554636, 0.6948701784014701, 0.6930635556578636, 0.6927630672231316, 0.6950279283523559, 0.69597077999264, 0.6977612240612507, 0.6990502294898033, 0.701474586725235, 0.7025039067864418, 0.7047207182645798, 0.7052646528556943, 0.7060384179651737, 0.7066090171039104, 0.7081083738803864, 0.709414926096797, 0.7106330419331789, 0.7139573331922293, 0.7126503324508667, 0.7141012969613075, 0.7153687426447868, 0.7165940938889981, 0.7175737310200929, 0.7192290733754635, 0.7189032457768917, 0.721599500104785, 0.7223168982565403, 0.7243244730308652, 0.7247243559360504, 0.7268680453300476, 0.7276349361240864, 0.7280418325960636, 0.7277660523355007, 0.729327140301466, 0.7308696354925632, 0.7306502954661847, 0.734322057440877, 0.7343895424902439, 0.733771161288023, 0.7366406504809856, 0.7351608783006668, 0.7369495616853237, 0.7378093709796667, 0.7398035801202059, 0.7406393891572952, 0.742212688177824, 0.7445512180030346, 0.7444861912727356, 0.7443586838245392, 0.7449799484014511, 0.7473554277420044, 0.7483780185878277, 0.748582693785429, 0.748348115682602, 0.7496187850832939, 0.7512771032750607, 0.7526918260753155, 0.7514966924488544]
SGDPos3 = [0.42453572928905486, 0.367522524446249, 0.3409422092139721, 0.31114192396402357, 0.29353559017181396, 0.3076406293362379, 0.2771377676725388, 0.27418168902397155, 0.2866455490142107, 0.2632733956724405, 0.27539820075035093, 0.2598408342897892, 0.2526075346022844, 0.2587633716315031, 0.2531910233944654, 0.24694363839924335, 0.25273000217974184, 0.25292618773877623, 0.25641664288938043, 0.2617539817094803, 0.25876632772386077, 0.27150695472955705, 0.2694759910181165, 0.2576214584708214, 0.27432746976614, 0.31848480775952337, 0.2693543291836977, 0.2728480089455843, 0.2949916209280491, 0.2696807723492384, 0.29522522501647475, 0.2822073807567358, 0.28893391229212284, 0.2882521516084671, 0.30503748238086703, 0.30771813102066514, 0.3288694391399622, 0.33297901071608066, 0.32505776688456534, 0.3367607644945383, 0.3427131959795952, 0.32577022030949593, 0.3488626313954592, 0.35232294254004953, 0.3704276559501886, 0.36674979865550994, 0.37086397394537923, 0.36466633066535, 0.3653067016601563, 0.4094472422450781, 0.3960672976076603, 0.41717263638973234, 0.41981550872325896, 0.4088718389719725, 0.43184000439941883, 0.42156882289797065, 0.4176812872290611, 0.45022597938776016, 0.44489230051636697, 0.45145647048950194, 0.441743480861187, 0.4828746221959591, 0.4636847297102213, 0.48367292553186414, 0.46879600755870343, 0.48014129981398584, 0.4863277542591095, 0.48840461902320387, 0.5037789325416088, 0.519112890958786, 0.5116242988780141, 0.5229513457417488, 0.5363710656389594, 0.5247732749953866, 0.5297200805693865, 0.5377089141309261, 0.5468350789695978, 0.5554931887239217, 0.5537701983004808, 0.5554315204918384, 0.5689538522809744, 0.5655913087725639, 0.5697812406718731, 0.5808136473968625, 0.5822546631097794, 0.5932139220833779, 0.58647918574512, 0.5924297510087491, 0.5987966897711158, 0.59727588519454, 0.6008399039506912, 0.6038666483387352, 0.6140410877764225, 0.6118102563917637, 0.618996772095561, 0.6190205395221711, 0.6210978640615941, 0.6270996969938278, 0.6235947092622518, 0.6298084389418364, 0.6307599213719368, 0.6363642920553684, 0.6395203086733818, 0.6416965974867344, 0.6460417138040065, 0.6486890745162964, 0.6488045033067464, 0.6470974576473236, 0.6540395132452249, 0.6572867348790169, 0.6576544557511806, 0.6579596385359764, 0.6622704537212849, 0.662219467908144, 0.6631694549322128, 0.6662432371079922, 0.6687410078942776, 0.669041495025158, 0.6756080198287964, 0.676953781992197, 0.6794821965321899, 0.6780243772268295, 0.6804841554164887, 0.6836742608994245, 0.6859859086573123, 0.6869298815727234, 0.6892122804373503, 0.6938169302046299, 0.6934625590592622, 0.6965529084205627, 0.697991283684969, 0.6968614245951176, 0.6988292165845632, 0.6997773298621177, 0.7006305342912674, 0.7053722310066223, 0.7059480307996273, 0.7080903233587742, 0.7105128607526422, 0.708580344170332, 0.7120075237751007, 0.7122067867219448, 0.7134190259873867, 0.7184969568252564, 0.7164524823427201, 0.7196861753799021, 0.7190038216114044, 0.7204731371253729, 0.7227893666177988, 0.7245059628784657, 0.7254825972020627, 0.7264439848065376, 0.7303922209143638, 0.7316198651492596, 0.7322532965987921, 0.7318654619157314, 0.7335055683553219, 0.7338787679374218, 0.7379317307472228, 0.7395274583622813, 0.7388120158016682, 0.7395756360143423, 0.7410448457300663, 0.7422013040073216, 0.7448496840894222, 0.7460481332242489, 0.7449012912809849, 0.7462360575795174, 0.7479398857057095, 0.75010006159544, 0.7507815337926149, 0.7514751886576414, 0.7537326852232218, 0.7543856377899647, 0.7554978789389133, 0.7560474642366171, 0.7567000006139278, 0.7569197085499764, 0.7595396600663662, 0.7607871763408184, 0.7618581640720368, 0.7632912343367935, 0.7629248857498169, 0.7650172199308872, 0.7648241774737835, 0.7666679511964322, 0.7666579333692789, 0.7698677136003971, 0.7707707890123129, 0.7702537897974253, 0.7714438384771347, 0.7719728542864323, 0.7733749502152204, 0.7749364627152682, 0.7759982962906361, 0.7760963201522827, 0.777907164990902, 0.7777737674117088, 0.7791506016999483, 0.7796144166588783]
SGDPos5 = [0.43855322420597076, 0.3712710629403591, 0.3473979778587818, 0.30980267241597176, 0.29444370418787, 0.3078414034098387, 0.2784605395793915, 0.2755830354988575, 0.28163805805146697, 0.2668647786974907, 0.2790020434558392, 0.26589800760149956, 0.2546716735512018, 0.2635074357688427, 0.2552171790599823, 0.25301797591149805, 0.2556002228707075, 0.2514264866709709, 0.2556174173951149, 0.267867276892066, 0.2518955322355032, 0.2678389921039343, 0.26560064770281316, 0.2596263821423054, 0.26750347450375556, 0.3007134683430195, 0.2668232037127018, 0.2705266486108303, 0.2967514383047819, 0.2680904233083129, 0.2884547163546085, 0.29015274047851564, 0.28978243812918664, 0.30129235312342645, 0.3024521441757679, 0.3165783856809139, 0.32807077616453173, 0.3196035373210907, 0.32241709873080254, 0.33570259720087053, 0.33808450609445573, 0.34565396010875704, 0.3467646875232458, 0.35317516908049584, 0.35481989599764346, 0.3561369273811579, 0.3647253356128931, 0.3772984088212252, 0.3786982273310423, 0.408701112344861, 0.39505386918783186, 0.40995453737676146, 0.3954288708418608, 0.41113862752914426, 0.45285674422979355, 0.41602664716541765, 0.42978379923850296, 0.43555483520030974, 0.4372061797231436, 0.44474284663796426, 0.44367882832884786, 0.46147346138954165, 0.4619234358519316, 0.46731605410575866, 0.4711586859822273, 0.483859298042953, 0.4854210203886032, 0.49143382102251054, 0.500026140064001, 0.5036032108962536, 0.5049341585487127, 0.5114449720084667, 0.5178432277590036, 0.5192912516742945, 0.5348413179069758, 0.5386548913456499, 0.5403009641915559, 0.5479832361638546, 0.5460192748904228, 0.548328565955162, 0.5557827854156494, 0.5577471500635147, 0.5629377253353596, 0.5724067707359791, 0.5735213974118233, 0.5782251767069101, 0.5780591858923435, 0.5839564874768257, 0.5883411371707916, 0.5888141830265522, 0.5919145442545414, 0.5922296443581581, 0.6010221167653799, 0.6012778434157372, 0.6046350909024477, 0.6083111897110939, 0.6140274388343095, 0.6152835643291473, 0.6139967779815197, 0.6203217267245055, 0.6191549749672413, 0.6253885824978351, 0.6252801073342562, 0.6306366356462241, 0.6340398906171322, 0.6360154446959495, 0.6366431334614754, 0.6366773489117622, 0.642265719473362, 0.6433630222082138, 0.6464963977783919, 0.6474704960547387, 0.649132838845253, 0.6501223149895669, 0.6528534342348575, 0.6542470889538526, 0.6558331117033959, 0.65918033644557, 0.6622282847762108, 0.6634191355109215, 0.6667974587902427, 0.6663658988475799, 0.667999699562788, 0.6715974467247725, 0.6720522931218147, 0.6735660187900067, 0.6766893883422017, 0.6793382862955332, 0.6778894775360823, 0.6833358752727509, 0.6824604764580726, 0.68362594217062, 0.6864040657877922, 0.6872581338882446, 0.687912509739399, 0.6922270062565804, 0.6924426022171974, 0.694236820936203, 0.6952127154916525, 0.6966314370930194, 0.6969944050908089, 0.6987645614147187, 0.6989787367731333, 0.7033173407614232, 0.704637354016304, 0.7043546058237553, 0.7070873696357012, 0.7070411973446608, 0.7095492623746396, 0.7104573775827885, 0.7108801420032979, 0.7131452895700932, 0.7145584738999605, 0.7161772118508816, 0.717822670340538, 0.7179590067267418, 0.7189402964711189, 0.7201642198115588, 0.7228340069949627, 0.7240037152171135, 0.7222192802280187, 0.7261956342309713, 0.7264584770798683, 0.7274509876966476, 0.7308585298806429, 0.7309638170897961, 0.7306208723783493, 0.7333583682030439, 0.733519104719162, 0.7344616873562336, 0.7364313432574272, 0.7380025970935822, 0.7383402252197265, 0.7405433525145054, 0.7412195704877377, 0.742036914601922, 0.7429495383426548, 0.742735565379262, 0.744702982455492, 0.7460803682729602, 0.7452973958849907, 0.7484045044705272, 0.7482235264778138, 0.7500775671005249, 0.7500136997550726, 0.7508402420580387, 0.7523019571602344, 0.7550391151756048, 0.7550765223801136, 0.7555889212340117, 0.7559412638843059, 0.7578905127942562, 0.7578568720817566, 0.7596866599470377, 0.7594399526715279, 0.7622023870050907, 0.7619294506311417, 0.7629259226098657, 0.7635161620378494, 0.7642616966366768]
plt.plot(SGDTestEpochs, SGD, color='b', label="SGD")
plt.plot(SGDTestEpochs, SGDwReg, color='olive', label="SGDwReg")
plt.plot(SGDTestEpochs, SGDPos5, color='cyan', label="SGD+0.5")
plt.plot(SGDTestEpochs, SGDPos3, color='brown', label="SGD+0.3")
plt.plot(SGDTestEpochs, SGDPos1, color='r', label="SGD+0.1")
plt.plot(SGDTestEpochs, SGDNeg5, color='g', label="SGD-0.5")
plt.plot(SGDTestEpochs, SGDNeg3, color='y', label="SGD-0.3")
plt.plot(SGDTestEpochs, SGDNeg1, color='m', label="SGD-0.1")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
plt.yscale('log')
plt.legend()
plt.title("Test Losses of SGD on FashionMNIST")
plt.xlabel("Epochs")
plt.ylabel("Test Loss")
plt.savefig("FashionMNISTSGDwRegTestLosses")
plt.close()

SGDTrainEpochs = np.arange(200)
SGDTrainLosses = [1.4968674576282501, 1.293918532371521, 1.2292215949296952, 0.9804004076719284, 0.9999879897832871, 0.886202848315239, 0.8796372448205948, 0.8505681585073471, 0.8134010398387909, 0.7366325759887695, 0.7209753347039223, 0.7372035877108574, 0.6805987901091576, 0.6780949649214745, 0.6485490798950195, 0.601294565141201, 0.5653114631772042, 0.5669121929407119, 0.6285213246941567, 0.580470723927021, 0.5710285145044327, 0.5368232523202896, 0.5122510561347008, 0.5003083052635193, 0.585107729792595, 0.5151699791550637, 0.5818290437459945, 0.4961515902876854, 0.5014704887866974, 0.4721967278122902, 0.4471692899763584, 0.4300742436349392, 0.4631169739961624, 0.5330128117501736, 0.3613735492229462, 0.38648148718476294, 0.43616018891334535, 0.338933499276638, 0.3884743931889534, 0.37530326133966446, 0.5062388269305229, 0.3602534209191799, 0.380440580368042, 0.3292758114039898, 0.3187558943331242, 0.32735261440277097, 0.3212804785966873, 0.3863341165781021, 0.3245091961324215, 0.4041825600862503, 0.3279536705315113, 0.2946533820927143, 0.3590521339774132, 0.24517365992069245, 0.2720173400044441, 0.30715393626689913, 0.3931242461502552, 0.3653026395142078, 0.3706856234371662, 0.27153764010965825, 0.32291710793972017, 0.3183414787054062, 0.29649336664378645, 0.24799980713427067, 0.27697696359455587, 0.4597909408211708, 0.39047616812586783, 0.31876451167464254, 0.29970356841385365, 0.26867449666559695, 0.3635669920742512, 0.27394248834252355, 0.2275276509076357, 0.2842023793756962, 0.25197288861870765, 0.32940970739722253, 0.29232837665081024, 0.38275115382671354, 0.5081705325841903, 0.23771799448132516, 0.22680281238257885, 0.3759814146310091, 0.32425510689616205, 0.3834709749221802, 0.2291570728495717, 0.2423241015225649, 0.26488611552119257, 0.24108073045313358, 0.2040291792601347, 0.301750441044569, 0.24199126449227332, 0.42705712428689, 0.2571692631244659, 0.3473170489668846, 0.2969870313704014, 0.2380921526104212, 0.23605404223501683, 0.19013463232666253, 0.3367697336524725, 0.18178087133169174, 0.47254861423373223, 0.3157571625560522, 0.2754610594063997, 0.18794982109218836, 0.24396079517900943, 0.3422068701088429, 0.2668598778694868, 0.3273678324371576, 0.338355834543705, 0.25725995425879955, 0.49634114634990695, 0.38568146599829195, 0.2300661587640643, 0.22952061314880848, 0.30981129921227696, 0.4426045091301203, 0.19083190842717887, 0.19785025063157083, 0.3372764817774296, 0.3594718541949987, 0.37480031377077105, 0.5233295688927173, 0.2545165603160858, 0.22813622339069844, 0.5740078802108765, 0.5012179368585348, 0.40068191339075565, 0.44846393506228927, 0.6211357131004334, 0.3553340966999531, 0.49137456133961677, 0.3395509683787823, 0.4333487338423729, 0.33929878325760365, 0.21032887351885438, 0.2202514503262937, 0.24901686450093985, 0.2611300074309111, 0.3874599495381117, 0.20759317620843648, 0.4527534326612949, 0.2828221721574664, 0.6232443951368332, 0.710983108073473, 0.3258391712754965, 0.3364088753014803, 0.2790240368694067, 0.30247677213698626, 0.30239163871854546, 0.23712172340601684, 0.39431501127779484, 0.25290238507092, 0.8149437814354896, 0.2680712323188782, 0.32535382433980703, 0.35654230549931526, 0.3592008334249258, 0.2538881093338132, 0.3041649336144328, 0.22896039921790362, 0.4437329167947173, 0.5137369284629821, 0.4024407864958048, 0.46975488401949406, 0.294719829544425, 0.707015129595995, 0.5632905069589614, 0.34358292385935785, 0.39434998460114, 0.6094709174335002, 0.31027560675144195, 0.28710917209088804, 0.260666483156383, 0.4185392896234989, 0.3867386999875307, 0.4034132301658392, 0.19299768540263176, 0.256738108497113, 0.2926973966807127, 0.24751557407528163, 0.42892740350961683, 0.2969698874950409, 0.20946265906840564, 0.3391831694543362, 0.36041375998407604, 0.37879520605504513, 0.3017732596285641, 0.35339957036823033, 0.28204272327572105, 0.4378866511583328, 0.3184937910437584, 0.6494301247596741, 0.4911352853477001, 0.8099365724921227, 0.3880762567818165, 0.44761986543238164, 0.3974871441572905, 0.6723838132619858, 0.38409933377057315, 0.41230608808994296]
SGD10TrainLosses = [1.738538950920105, 1.4648326549530029, 1.3255813031196595, 1.2289721269607543, 1.2413607794046402, 1.1223616371154785, 1.054577865242958, 1.0310529164075852, 1.026462532877922, 0.9765656832456588, 0.9802803362607956, 0.9121322441101074, 0.9106563466787339, 0.9448059968948365, 0.9653126281499863, 0.856921411037445, 0.8272546130418778, 0.8388045271635055, 0.846831616640091, 2.342124645233154, 2.3113275604248047, 2.3259061574935913, 2.3053088002204896, 2.3048881311416625, 2.3036046833992003, 2.3027322363853453, 2.3027134313583373, 2.302758240699768, 2.3027187438011167, 2.3027069296836853, 2.3026897597312925, 2.3026516461372375, 2.3026703443527223, 2.3027232584953308, 2.302649666786194, 2.302787083148956, 2.302664322376251, 2.302653088092804, 2.3028080749511717, 2.30276966047287, 2.3027721757888795, 2.302749771118164, 2.3026658101081847, 2.3027406635284424, 2.3027190837860108, 2.302860695838928, 2.302741270542145, 2.3027796063423156, 2.302773892879486, 2.302682552814484, 2.302655206680298, 2.3027622241973877, 2.3027595291137697, 2.3026429586410524, 2.302696669101715, 2.302860852718353, 2.3026107625961303, 2.302652968406677, 2.302692454338074, 2.3027666845321657, 2.302727321147919, 2.302722544193268, 2.302694071292877, 2.3026670155525206, 2.302690118789673, 2.3028442130088806, 2.3026677198410033, 2.3027346467971803, 2.302724925994873, 2.3026251611709596, 2.302683759212494, 2.3027054867744448, 2.3026777620315553, 2.302763357639313, 2.3026544113159177, 2.3027110500335692, 2.302759484767914, 2.3026818261146547, 2.302708429813385, 2.3026944899559023, 2.3027546973228454, 2.302724413394928, 2.3027024273872376, 2.3026344361305235, 2.3026989426612854, 2.302654601573944, 2.3026589546203615, 2.3026461472511293, 2.3026591410636903, 2.3027458992004393, 2.3025970520973207, 2.3026920890808107, 2.302780364513397, 2.3027281064987184, 2.302739709854126, 2.3029500660896303, 2.302835110664368, 2.3028186535835267, 2.3027973589897157, 2.3026483960151674, 2.302647015094757, 2.3027034001350404, 2.302721351146698, 2.302677942276001, 2.3026452040672303, 2.3027987756729127, 2.3026932940483094, 2.302653766155243, 2.3027371497154236, 2.302772974014282, 2.3026737961769106, 2.302697225570679, 2.3026753396987916, 2.302817896366119, 2.3027609934806823, 2.3026874299049376, 2.30267559671402, 2.3027187304496763, 2.3027020964622498, 2.3026554341316223, 2.3027524099349974, 2.302744322299957, 2.302765709400177, 2.3026155285835266, 2.3026517000198363, 2.3029614477157594, 2.302710919380188, 2.302640290260315, 2.302699321746826, 2.302758385181427, 2.3026873574256896, 2.302703724384308, 2.302750319004059, 2.302748240470886, 2.302668241977692, 2.302757908821106, 2.3027389211654663, 2.3026160683631898, 2.3026729941368105, 2.3026863059997558, 2.3026914052963257, 2.302639796257019, 2.302686896800995, 2.302618907928467, 2.3027012519836427, 2.302676146507263, 2.3027993774414064, 2.3026685123443604, 2.3026387591362, 2.302770130634308, 2.3027525372505186, 2.3027019996643068, 2.302615406036377, 2.3027565212249756, 2.302707227706909, 2.302689033985138, 2.302809648036957, 2.3027129163742064, 2.302631248474121, 2.302702527999878, 2.302788992881775, 2.3027285075187685, 2.3027869944572448, 2.302638204574585, 2.3026261553764344, 2.3027721495628355, 2.302782557487488, 2.3027694902420044, 2.3026322422027587, 2.3026991682052613, 2.3026435165405275, 2.302707483291626, 2.30280214881897, 2.302745723724365, 2.302663019657135, 2.3026575946807863, 2.3026623525619505, 2.302681296825409, 2.302678909778595, 2.3026933240890504, 2.3026149048805236, 2.302620756149292, 2.302708808422089, 2.3027139410972595, 2.3027177453041077, 2.3026848802566526, 2.3026524610519408, 2.302666263103485, 2.302629243373871, 2.3026226568222046, 2.302683176040649, 2.302648681640625, 2.3026726412773133, 2.3026894946098326, 2.3027011914253235, 2.302773575782776, 2.302655089378357, 2.302728352546692, 2.3028038897514342, 2.3027057704925538]
SGD20TrainLosses = [1.939607502937317, 1.6935343296527863, 1.5229810547828675, 1.4144925570487976, 1.3944134991168975, 1.277769887447357, 1.2399152055978775, 1.2125138849020005, 1.1730907349586486, 1.1777991198301316, 1.1395697985887527, 1.1008012455701828, 1.0834156258106231, 1.0986549426317216, 1.0660729768276214, 1.037002619743347, 1.0213678274154663, 1.0161792551279067, 1.0157720133066177, 1.0325399301052094, 1.008831021308899, 0.9866587067842484, 0.9669292995929718, 0.9745344554185867, 0.9804906387329102, 0.9278147481679916, 0.9547012441158295, 0.9269824447631836, 0.9067772611379623, 0.9477684557437897, 0.9171606241464615, 0.895921648979187, 0.9235748467445374, 0.8803202867507934, 0.8767957504987717, 0.8622355439662933, 0.8782547900676727, 0.8646155073642731, 0.8695741665363311, 0.8752692995071412, 0.8339261429309845, 0.8405101599693299, 0.9605897550582886, 0.8492870230674744, 0.9066597337722778, 0.8372029550075532, 0.8344474366903305, 0.8211844873428344, 0.8125271916389465, 0.8875135397911071, 0.8433255838155747, 0.8552986018657684, 0.8571007310152053, 0.8336269571781159, 0.775322098493576, 0.7614213460683823, 0.7649393209218979, 0.7893050000667572, 0.9599004060029983, 0.7587009156942368, 0.7815540589094162, 0.7852732529640197, 0.7747980288267136, 0.77118184196949, 0.8116314647197723, 0.7903269313573837, 1.8941816132068634, 1.380716004371643, 1.2075667392015457, 1.163435985803604, 1.1300519580841064, 1.2654288635253905, 1.1774232524633408, 1.1210818955898285, 1.025299215078354, 1.0272458057403564, 1.0391442167758942, 1.0246562985181809, 1.02485404419899, 1.029650141596794, 1.0714503959417343, 1.003185197710991, 1.0395315623283385, 0.9674990922212601, 1.0435515148639678, 0.9759499199390411, 0.9573535104990005, 0.9512849583625793, 0.9796952579021454, 1.0031079733371735, 1.0332618190050125, 0.9775744160413742, 0.9431201139688492, 0.9210485581159592, 0.9286591583490371, 0.9450752565860748, 0.9160053817033768, 0.9198983111381531, 0.9827205002307892, 0.9602772356271744, 0.9852118678092957, 0.9046404811143876, 0.9215019047260284, 0.9052560307979584, 0.8985191750526428, 0.9351962321996689, 0.8801418515443802, 0.9439400705099106, 0.9319064470529557, 0.9561900572776795, 0.9576765316724777, 0.8900278151035309, 0.9620197352170944, 0.8912800192832947, 0.8999846564531326, 0.8839132758378982, 0.8932294812202454, 0.8637985744476319, 0.9026890741586685, 0.8697932847738266, 0.9472087041139603, 0.908416343331337, 0.9624995635747909, 0.8868417476415634, 0.8669409775733947, 0.8454160982370377, 0.845458604812622, 0.8435532450675964, 0.8780849032402038, 0.8678281282186509, 0.9153904745578766, 0.8469563663005829, 0.8466995166540146, 0.9119146287441253, 0.8607375935316086, 0.8726332850456238, 0.8669172296524048, 0.8947010204792023, 0.8373917989730835, 0.8436235196590424, 0.8638619908094406, 0.8409489287137986, 0.8846786545515061, 0.8927674857378006, 0.9012329816818238, 0.871690408706665, 0.8345370637178421, 0.8258594835996628, 0.8553740235567093, 0.8666944520473481, 0.8710929003953933, 0.8574433846473694, 1.0191078075170517, 1.0570615526437759, 0.9046798098087311, 1.0140077440738677, 0.857687308549881, 0.9429784883260727, 0.9139601739645005, 1.1203972973823548, 0.9250330988168717, 0.9797405591011047, 1.0229957067966462, 0.9338851597309112, 0.8819781285524368, 0.8698059594631196, 0.8729747642278671, 0.8757541954517365, 1.0864740476608277, 0.8630215721130371, 0.845507817029953, 0.8593537006378174, 0.8651678401231766, 0.8855169186592102, 0.8536724678277969, 0.8531202192306518, 0.8758461518287659, 0.850110025048256, 0.8714943633079529, 0.863023921251297, 0.8333214612007142, 0.8412611248493195, 0.8269760715961456, 0.8425721913576126, 0.8816039552688598, 0.857660019993782, 0.8573116149902343, 0.8342296125888824, 0.9838981035947799, 0.8194345932006836, 0.9102699542045594, 0.8454678707122802, 0.8054287039041519, 0.8345720735788346, 0.7938359198570252, 0.8358621898889541, 0.8074204641580581, 0.9667915494441987, 0.9466568267345429, 0.9009554555416107]
SGD30TrainLosses = [2.15982611989975, 1.8773016917705536, 1.7063868927955628, 1.5808479869365692, 1.5260951056480407, 1.4279221811294556, 1.3842343773841859, 1.3461077969074249, 1.303019701242447, 1.286700262784958, 1.279910144329071, 1.2202303853034973, 1.2042012687921524, 1.211868386387825, 1.1885620898008347, 1.153123339176178, 1.161502796649933, 1.1277175852060317, 1.1619704753160476, 1.1132252068519592, 1.1333948732614518, 1.11304807472229, 1.1040883878469467, 1.1016338139772415, 1.1055862530469895, 1.06797813475132, 1.0794542783498764, 1.09014510345459, 1.0400130834579469, 1.0883572959899903, 1.049641943693161, 1.0244430532455444, 1.0615536563396455, 1.0583361483812332, 1.0605031229257584, 1.0332802437543869, 1.0466016535758973, 1.0212758544683456, 1.0342893561124802, 1.053857338309288, 1.004060446381569, 1.001281189918518, 1.066716938495636, 1.0066159740686416, 1.0255388303995132, 0.993947499871254, 1.0026503162384033, 0.979671298623085, 0.95529201233387, 0.9685931279659271, 0.9800143233537674, 0.9597200986146927, 0.9761698470115662, 0.9537721256017685, 0.9462231072187424, 0.9301207202672959, 0.9198681765794754, 0.9524798640012742, 0.9710789808034896, 0.9280960929393768, 0.9779672461748123, 0.9606220797300339, 0.9263457109928132, 0.922000764966011, 0.9656803936958313, 0.9239159588813781, 0.9221226105690002, 0.8969481225013733, 0.9215692164897918, 0.9017526360750199, 0.9398488965034485, 0.8926669269800186, 0.8957841354608536, 0.9066316813230515, 0.9217465723752976, 0.9080105270147324, 1.0174437670707703, 0.8971774382591248, 0.8653461558818817, 0.9282414575815201, 0.8762101616859436, 0.9758305513858795, 1.1247786183357238, 0.8636485126018524, 0.8673625396490097, 0.8790776505470276, 0.8572677611112595, 0.8755431650876999, 0.8926296608448029, 0.828427944302559, 0.8457042602300644, 0.8580417507886886, 0.8197560254335403, 0.8120448960065841, 0.8791385278701782, 0.8441226400136947, 0.8288177752494812, 0.8481044362783432, 0.830889167547226, 0.806521499633789, 0.8596370503902435, 0.8294677783250809, 0.8181550406217575, 0.822455150604248, 0.7871041107177734, 0.8293611520528793, 0.8478493821620942, 0.9203097388744355, 0.7892717391252517, 0.818393357515335, 0.795271632552147, 0.8069280339479447, 0.8461528301239014, 0.8080426061153412, 0.8042104797363281, 0.7663661677837372, 0.8111121903657913, 0.7744170877933502, 0.7985588313341141, 0.8218923127651214, 0.7976639832258224, 0.7814737538099289, 0.9454820983409882, 0.7931521257162094, 0.7786506108045578, 0.9084123249053955, 0.8039333380460739, 0.7383425019979477, 0.8409693975448609, 0.7710302174091339, 0.795522878408432, 0.7616602022647858, 0.7652243560552597, 0.7788982796669006, 0.7763801656961441, 0.849062912106514, 0.7445857501029969, 0.8406273462772369, 0.763540281534195, 0.7669482436180115, 0.7547506701946258, 0.7298787529468537, 0.721027728676796, 0.9712331631183624, 0.8708581845760346, 0.7700975914001464, 0.7985434699058532, 0.7098171820044518, 0.7625095090866089, 0.8078028358221054, 0.7635284575223923, 0.9691872719526291, 0.9419447495937348, 0.9449823160171509, 0.8696867270469666, 0.8464695032835007, 0.817061212182045, 0.7900549788475036, 0.8058245192766189, 0.8418200522661209, 0.8519611806869507, 0.8935215593576431, 0.8336458740234375, 0.7894698452949523, 0.8166313687562943, 0.8200737698078155, 0.7727251925468445, 0.8581680213212967, 0.7888546802997589, 0.7901342515945434, 0.8090575624704361, 0.7904875999689103, 0.8018209080696106, 0.7676600979566575, 0.7682096900939941, 16.77012123680115, 6.412356537342071, 5.889443023204803, 5.368569534301757, 4.847597325325013, 4.3265220041275025, 3.805552551746368, 3.2847348108291627, 2.764451602935791, 2.3348464326858522, 2.3026784057617187, 2.302674572944641, 2.3026904678344726, 2.302651324272156, 2.302644639968872, 2.302708607196808, 2.302672480583191, 2.3026987586021423, 2.3027145347595215, 2.3027271852493287, 2.302803611278534, 2.3026800022125244, 2.302756217956543, 2.3028365621566773, 2.302734041213989]
SGD40TrainLosses = [2.2553366479873658, 2.0606076743602753, 1.8850198311805726, 1.756015183210373, 1.666745949268341, 1.5816419160366058, 1.5405145375728606, 1.5065567481517792, 1.4468791761398316, 1.4439472279548644, 1.4115386991500853, 1.361660034418106, 1.3482708172798157, 1.3415782260894775, 1.331013772249222, 1.2948638639450074, 1.2910193092823028, 1.271032773733139, 1.2954247839450836, 1.2394537682533264, 1.296500837802887, 1.2490569713115691, 1.227897477030754, 1.2386521890163422, 1.2356174957752228, 1.1868150725364686, 1.2366910814046859, 1.2157214236259462, 1.2095311552286148, 1.2276173689365386, 1.1955344059467317, 1.1730681077241898, 1.2645399124622345, 1.1695230218172072, 1.1819089287519455, 1.1605042493343354, 1.1627529510259629, 1.1431556777954102, 1.1542841794490815, 1.154880935549736, 1.1351414686441421, 1.1342511751651765, 1.2231159181594848, 1.1309140704870224, 1.1458928517103195, 1.1610466550588607, 1.1497028968334198, 1.0936386349201201, 1.0892432705163955, 1.102344755768776, 1.1545743480920792, 1.1000189896821975, 1.081360219836235, 1.1154801201820375, 1.079343684196472, 1.0573145917654037, 1.0574785495996475, 1.0838489817380905, 1.0780900933742523, 1.056016014456749, 1.1126927884817124, 1.1052005459070207, 1.067922995686531, 1.059352725982666, 1.0704391986131667, 1.06424218416214, 1.0820604935884475, 1.063971935391426, 1.0720312215089798, 1.0742548648118972, 1.0486284395456313, 1.0419762951135636, 1.0447627732753753, 1.0677261916399001, 1.033494480729103, 1.0259579198360442, 1.169413661122322, 1.057899118900299, 1.052785634160042, 1.084416006565094, 1.06938048350811, 1.1576065896749497, 1.152086884021759, 1.1699263980388641, 1.0450234713554383, 1.0907956980466842, 1.035148446559906, 1.0257693265676497, 1.0642645627260208, 1.0120295433998108, 1.0442665157318116, 1.038436915755272, 1.0330091948509217, 1.0169277549982072, 1.0174966683387756, 1.0683455197811127, 1.04838540661335, 1.0438951588869094, 1.1024277116060257, 1.0354410794973374, 1.085694052696228, 1.0501045715808868, 1.0679736647605895, 1.0446870998144149, 1.0629052072763443, 1.0434185296297074, 1.0368793897628785, 1.0360027105808258, 1.0311708114147187, 1.0433786727190018, 1.05032870221138, 1.0332163769006728, 1.0612703763246536, 1.0255866297483445, 1.035184269785881, 0.9913732640743256, 1.0733363391160966, 0.9884220360517502, 1.0443339600563049, 1.003784476518631, 1.0045500260591507, 1.0367275208234787, 1.04189579474926, 1.0033021069765091, 1.0203884459733963, 1.0116442456245422, 0.9834308762550354, 0.9928256088495254, 1.0254139276742935, 1.0001806812286378, 1.0614534618854523, 1.0542040433883666, 1.0042982251644135, 1.0359038853645324, 1.0276157920360565, 1.0643562412261962, 1.1176583136320115, 1.1276985535621642, 1.074055167913437, 1.049644328713417, 1.033657302379608, 1.045171520113945, 1.052104859828949, 1.2022727913856506, 1.0630554486513137, 1.0290588644742966, 1.0660352631807328, 1.0956891803741455, 1.0696979497671126, 1.0314773253202438, 1.0819512946605683, 1.0587774251699447, 1.0124117257595062, 1.055718649148941, 1.0131041142940522, 1.020865778207779, 1.0221863169670105, 1.0369195170402528, 1.1030658794641495, 1.0117638411521912, 1.018835154414177, 1.002469089269638, 1.075250497341156, 1.004557909488678, 0.984167936205864, 0.9938423056602478, 0.9961503423452377, 1.03155442237854, 0.9858922163248062, 1.0050041563510894, 1.0210782815217971, 1.007309719800949, 1.047962359547615, 1.0546907032728194, 0.9939309653043747, 1.0655894628763198, 1.0267822974920273, 1.0079764504432678, 1.0105317593812944, 1.0550013256072999, 1.0092795596122741, 1.010776376247406, 1.030368824005127, 1.0063567262887956, 0.9803077059984208, 0.9853652285337449, 1.024320032119751, 1.0377557761669158, 1.026062286734581, 0.9994279069900512, 1.0607970179319381, 1.0192945283651351, 1.0117628309726716, 1.0411687040328979, 1.06888591837883, 1.0231402567625045, 1.0133309491872788, 1.0035555913448333, 1.002534950375557, 1.0075770971775055]
plt.plot(SGDTrainEpochs, SGDTrainLosses, color='b', label="SGD")
plt.plot(SGDTrainEpochs, SGD10TrainLosses, color='r', label="SGD10")
plt.plot(SGDTrainEpochs, SGD20TrainLosses, color='g', label="SGD20")
plt.plot(SGDTrainEpochs, SGD30TrainLosses, color='y', label="SGD30")
plt.plot(SGDTrainEpochs, SGD40TrainLosses, color='m', label="SGD40")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
plt.yscale('log')
plt.legend()
plt.title("Train Losses of SGD with Regularizations on Cofar10")
plt.xlabel("Epochs")
plt.ylabel("Train Loss")
plt.savefig("Cifar10SGDwRegTrainLosses")
plt.close()

SGDTestEpochs = np.arange(200)
SGDTestLosses = [1.498619589805603, 1.3172639417648315, 1.2741955244541168, 1.0609892308712006, 1.092958806157112, 1.0159605664014817, 1.0250715029239654, 1.0200347673892975, 1.0111128741502762, 0.9549398761987686, 0.9634730398654938, 1.0001643991470337, 0.9587676024436951, 0.954546657204628, 0.96185391664505, 0.9544830793142318, 0.943178351521492, 0.9433845204114913, 1.0263859385251999, 1.0251156973838806, 1.0065705054998397, 1.0296697509288788, 1.0064200061559676, 1.0257463538646698, 1.0917481064796448, 1.0422643673419953, 1.14920078933239, 1.0819977742433549, 1.1087674862146377, 1.0758067524433137, 1.1150779914855957, 1.0924188256263734, 1.1963637429475784, 1.2348516207933427, 1.1177134001255036, 1.1476595216989518, 1.2184102493524551, 1.1545064157247544, 1.2290556967258452, 1.2305371230840683, 1.3483317875862122, 1.261756642460823, 1.3314930897951127, 1.292454931139946, 1.2965299052000046, 1.30920476436615, 1.3373396331071854, 1.4464597928524017, 1.4148752576112746, 1.5041524946689606, 1.507412405014038, 1.4806760543584823, 1.5846264427900314, 1.461606879234314, 1.4833734899759292, 1.584149382710457, 1.673934395313263, 1.7246701753139495, 1.7229511308670045, 1.612357497215271, 1.6937831377983092, 1.6773223716020584, 1.7170489412546157, 1.7385044765472413, 1.7461228257417678, 1.9807522284984589, 1.907277021408081, 1.7879887473583223, 1.848420444726944, 1.894448810815811, 1.9587848377227783, 1.9406556510925292, 1.9434724354743957, 1.966405509710312, 2.0386610472202302, 2.086758170127869, 2.132226643562317, 2.2387991905212403, 2.3463560223579405, 2.0426118636131285, 2.1210101675987243, 2.30621794462204, 2.2240711081027986, 2.2722855150699615, 2.2073777878284453, 2.2608340191841125, 2.257619513273239, 2.283115881681442, 2.223663477897644, 2.3800920963287355, 2.376057665348053, 2.5539350163936616, 2.343737461566925, 2.488853349685669, 2.4637847197055818, 2.5060535871982577, 2.477226364612579, 2.486866250038147, 2.675104945898056, 2.5663482511043547, 2.874021238088608, 2.7041515815258026, 2.7001557409763337, 2.61368349313736, 2.698873851299286, 2.8659204709529877, 2.72125244140625, 2.7853103244304656, 2.801240142583847, 2.7464463758468627, 3.0191574585437775, 2.9629007709026336, 2.8531039237976072, 2.8814023470878602, 2.9369312143325805, 3.0135932290554046, 3.006171027421951, 2.8894778752326964, 3.11970384478569, 3.186071422100067, 3.1457793259620668, 3.3244457340240476, 3.137761106491089, 3.071739321947098, 3.446033546924591, 3.216598858833313, 3.312372531890869, 3.405039463043213, 3.602383511066437, 3.4007037794589996, 3.2877296781539918, 3.500514976978302, 3.5072060561180116, 3.4317810940742492, 3.312890148162842, 3.394301197528839, 3.5160474085807802, 3.2825214052200318, 3.4496164393424986, 3.403004207611084, 3.6409693241119383, 3.456240503787994, 3.7697662889957426, 4.03524607181549, 3.6735417890548705, 3.656756725311279, 3.6535762453079226, 3.722811040878296, 3.7212899231910708, 3.598933641910553, 3.7862679767608642, 3.4955468666553497, 4.131957731246948, 3.6422080302238466, 3.921967451572418, 3.7960028743743894, 3.854171040058136, 3.8539835572242738, 3.7968301129341127, 3.8808274054527283, 4.294724960327148, 4.144384510517121, 3.8814688754081725, 3.8239803314208984, 3.9430713486671447, 4.313871445655823, 4.298001954555511, 4.1357369804382325, 4.0527653932571415, 3.9847991251945496, 4.016695168018341, 3.905529360771179, 3.803230040073395, 4.09146210193634, 4.333051397800445, 4.108294909000397, 4.066214056015014, 4.053415197134018, 4.108497438430786, 4.155580494403839, 4.1096849954128265, 4.092586996555329, 4.193340253829956, 4.394638140201568, 4.236879532337189, 4.298825237751007, 4.404885504245758, 4.3979699063301085, 4.312165679931641, 4.731673407554626, 4.269724912643433, 4.590244526863098, 4.522204446792602, 4.74851803779602, 4.443427023887634, 4.683161437511444, 4.599493136405945, 4.8413580131530765, 4.492746531963348, 4.50611732006073]
SGD10TestLosses = [1.7331581139564514, 1.4682479977607727, 1.3410335993766784, 1.2521973991394042, 1.272712777853012, 1.1641304510831834, 1.1053196531534195, 1.0869802719354629, 1.0934379589557648, 1.0447684347629547, 1.0551674968004228, 0.994234670996666, 1.0014489430189133, 1.0332147574424744, 1.0554109960794449, 0.960894837975502, 0.9433127194643021, 0.950164052248001, 0.9629727321863174, 2.3421469783782958, 2.3113612937927246, 2.3259371638298036, 2.3053413820266724, 2.3049192357063295, 2.3036333441734316, 2.3027589249610902, 2.3027400588989257, 2.3027839636802674, 2.3027429223060607, 2.3027295899391174, 2.3027112555503844, 2.3026717281341553, 2.3026898241043092, 2.30274249792099, 2.3026683163642883, 2.302805540561676, 2.3026828718185426, 2.3026716685295106, 2.3028267288208006, 2.302788562774658, 2.302791097164154, 2.302768759727478, 2.3026848459243774, 2.302759702205658, 2.302738058567047, 2.3028797459602357, 2.302760291099548, 2.3027988028526307, 2.3027931118011473, 2.302701756954193, 2.3026744437217714, 2.3027815437316894, 2.3027789282798765, 2.3026623344421386, 2.302716157436371, 2.302880389690399, 2.302630276679993, 2.302672564983368, 2.302712070941925, 2.302786395549774, 2.3027470874786378, 2.3027422976493837, 2.3027139496803284, 2.302686984539032, 2.302710168361664, 2.3028643584251403, 2.302687826156616, 2.3027548885345457, 2.3027452349662783, 2.302645559310913, 2.3027041864395144, 2.3027260065078736, 2.3026983833312986, 2.3027841949462893, 2.302675223350525, 2.302732005119324, 2.3027804398536684, 2.3027029395103455, 2.302729570865631, 2.302715735435486, 2.302775988578796, 2.302745847702026, 2.3027240586280824, 2.302656075954437, 2.302720670700073, 2.302676477432251, 2.302680904865265, 2.302668128013611, 2.30268141746521, 2.3027682423591616, 2.3026194620132445, 2.302714612483978, 2.3028029704093935, 2.302750818729401, 2.3027626132965087, 2.302973039150238, 2.3028582382202147, 2.3028419423103332, 2.3028206491470335, 2.3026717925071716, 2.302670602798462, 2.302727119922638, 2.30274516582489, 2.3027019810676577, 2.3026693081855774, 2.30282301902771, 2.30271764755249, 2.302678310871124, 2.302761826515198, 2.3027976965904235, 2.3026987862586976, 2.302722375392914, 2.302700617313385, 2.302843241691589, 2.3027865362167357, 2.3027132606506346, 2.30270140171051, 2.302744801044464, 2.302728385925293, 2.302681767940521, 2.302778952121735, 2.302770993709564, 2.3027926301956176, 2.302642569541931, 2.3026788902282713, 2.302988798618317, 2.3027385091781616, 2.302667977809906, 2.302727210521698, 2.302786560058594, 2.302715575695038, 2.302732107639313, 2.3027789282798765, 2.3027769351005554, 2.302697274684906, 2.302787067890167, 2.3027682876586915, 2.3026456451416015, 2.3027026677131652, 2.302716212272644, 2.302721552848816, 2.3026700687408446, 2.3027174854278565, 2.3026496505737306, 2.3027322840690614, 2.3027073431015013, 2.302830753326416, 2.3027002024650574, 2.3026706981658935, 2.30280223608017, 2.302784950733185, 2.302734577655792, 2.3026481223106385, 2.3027894997596743, 2.3027404618263243, 2.3027224254608156, 2.3028433108329773, 2.3027466917037964, 2.3026653003692625, 2.3027368211746215, 2.3028235626220703, 2.302763276100159, 2.302821936607361, 2.3026734232902526, 2.3026616764068604, 2.3028080105781554, 2.3028185248374937, 2.3028055906295775, 2.3026688075065613, 2.3027358865737915, 2.3026806712150574, 2.302744996547699, 2.302839767932892, 2.3027837538719176, 2.3027012586593627, 2.3026961636543275, 2.3027012157440185, 2.3027205872535705, 2.302718467712402, 2.3027332997322083, 2.302655279636383, 2.3026615142822267, 2.3027498626708987, 2.302755491733551, 2.302759735584259, 2.3027272415161133, 2.3026955246925356, 2.302709610462189, 2.3026730394363404, 2.302666938304901, 2.3027279925346376, 2.3026933813095094, 2.3027178502082823, 2.302735376358032, 2.3027471041679384, 2.3028200006484987, 2.302701997756958, 2.302775409221649, 2.3028513526916505, 2.302753357887268]
SGD20TestLosses = [1.9356442022323608, 1.6946375250816346, 1.5309101927280426, 1.425331896543503, 1.4099779284000398, 1.3003601729869843, 1.2677638721466065, 1.2423813045024872, 1.2097648006677628, 1.2111258721351623, 1.1812345457077027, 1.1460544580221177, 1.1341657668352128, 1.1477390778064729, 1.1217920523881912, 1.0961024624109268, 1.0850869524478912, 1.0819183367490768, 1.0802978616952896, 1.094696774482727, 1.080446766614914, 1.065204513669014, 1.0463995134830475, 1.0536719870567322, 1.0624902057647705, 1.0158933508396149, 1.0427079796791077, 1.017498853802681, 1.0020070695877075, 1.039008070230484, 1.0169458723068237, 0.9965301805734634, 1.018444648385048, 0.9893858528137207, 0.9859363704919815, 0.9780125117301941, 0.9931394702196121, 0.9780712938308715, 0.9854815965890884, 0.9871141695976258, 0.9593103212118149, 0.9658690989017487, 1.0793292480707168, 0.9762973880767822, 1.0221170777082442, 0.9650960320234299, 0.9658278888463974, 0.9527561193704606, 0.9519603306055069, 1.0140781962871552, 0.9784415584802627, 0.9873689979314804, 0.9985409808158875, 0.9868032753467559, 0.9278486865758896, 0.9123487085103988, 0.9228376597166061, 0.9443060427904129, 1.0987397027015686, 0.9234466981887818, 0.9362425833940506, 0.9492952632904053, 0.9434843498468399, 0.9414836513996124, 0.9883185869455338, 0.9589636653661728, 1.8961912751197816, 1.4037508940696717, 1.2490206336975098, 1.2151016497612, 1.1852290856838226, 1.311168941259384, 1.2429270708560944, 1.18977090716362, 1.0968275904655456, 1.0986893486976623, 1.1127863281965256, 1.1035886216163635, 1.1063413840532303, 1.106460594534874, 1.1504643326997757, 1.0921086072921753, 1.1234670776128768, 1.060040082335472, 1.1286924493312835, 1.065754463672638, 1.0529279720783233, 1.0450114268064499, 1.0783093446493148, 1.0882423049211503, 1.1188701593875885, 1.073857700228691, 1.0451462805271148, 1.0249363267421723, 1.0326240652799605, 1.048365136384964, 1.0241481614112855, 1.0300153774023055, 1.0812226605415345, 1.05667151927948, 1.090402647256851, 1.0165194815397263, 1.032646895647049, 1.0152715927362441, 1.0159373092651367, 1.0431696766614913, 0.9975403118133545, 1.060640498995781, 1.0440760326385499, 1.0660720092058182, 1.0673761558532715, 1.0027687919139863, 1.0688970130681992, 1.0137958812713623, 1.0135363453626633, 1.013794902563095, 1.0204544746875763, 0.9940133666992188, 1.026894487142563, 0.9977654558420181, 1.068056384921074, 1.033688228726387, 1.0856513661146163, 1.012837736606598, 1.000343647003174, 0.9811932998895645, 0.9870723420381546, 0.9868596595525742, 1.0145388358831406, 1.0079151237010955, 1.0466268134117127, 0.9910880756378174, 0.9864290601015091, 1.0438703870773316, 1.0085632658004762, 1.014906103014946, 1.003523930311203, 1.0398555892705916, 0.9835762679576874, 0.9923815369606018, 1.0105736857652665, 0.9908909398317337, 1.0199542957544327, 1.0284323906898498, 1.0347317337989808, 1.0180647826194764, 0.9868620222806931, 0.9761138707399368, 1.0058576321601869, 1.007217711210251, 1.021152673959732, 1.0119886982440949, 1.1329806941747664, 1.1839054656028747, 1.0399063396453858, 1.138270548582077, 1.0010643661022187, 1.0725150054693222, 1.0427762579917907, 1.216511431336403, 1.0619201731681824, 1.1055343359708787, 1.1350975584983827, 1.0692196685075759, 1.024258621931076, 1.015880588889122, 1.0162456971406937, 1.0237166410684586, 1.1916533815860748, 1.0148492515087129, 1.001698119044304, 1.0028577935695648, 1.0163429069519043, 1.0358811277151108, 1.0123634284734726, 1.0075662106275558, 1.0286586558818818, 1.0117476111650467, 1.0219411033391952, 1.0147948437929153, 0.9999939376115798, 1.0039566624164582, 0.9938849675655365, 1.004823422431946, 1.0398148506879807, 1.0099173533916472, 1.0207367259263993, 1.0105907952785491, 1.1348199498653413, 0.9938960307836533, 1.0608598291873932, 1.0089737993478776, 0.9786138737201691, 1.0022971522808075, 0.9667127233743668, 1.0061892920732498, 0.9821902364492416, 1.1081461876630783, 1.0793222522735595, 1.0437324929237366]
SGD30TestLosses = [1.9364934861660004, 1.6926639187335968, 1.531572242975235, 1.4285454058647156, 1.4161636078357696, 1.3024446094036102, 1.2679243636131288, 1.2443356204032898, 1.2080780458450318, 1.2156236922740937, 1.1832627594470977, 1.147576141357422, 1.1321830874681473, 1.1502654093503952, 1.1267666900157929, 1.0929470229148865, 1.0838135415315628, 1.0884466630220413, 1.0719062447547913, 1.0786562806367874, 1.0812440311908722, 1.0842399179935456, 1.0451851516962052, 1.0489993262290955, 1.0712735176086425, 1.0151652711629868, 1.0280770176649094, 1.0260154432058335, 1.0068463164567947, 1.0331087410449982, 1.0185905921459197, 0.9839081454277039, 1.0321363353729247, 1.0005720913410188, 0.9828553026914597, 0.9823449486494065, 1.010972256064415, 0.9774339216947555, 1.0307504558563232, 0.9870269638299942, 0.956084355711937, 0.9626376134157181, 1.017184322476387, 0.989213387966156, 1.184605228304863, 0.9732945781946182, 1.0802216267585754, 1.0307711601257323, 0.9893777322769165, 1.0065786737203597, 1.014585531949997, 1.019615690112114, 0.9909539288282394, 1.0043795400857924, 0.9569633114337921, 0.9283176785707474, 0.9300385254621506, 0.9978786081075668, 0.9686311382055283, 0.9351537615060806, 0.9831308817863464, 0.9486880177259445, 0.9911557585000992, 0.9778473973274231, 0.9525563234090805, 0.9313424670696259, 0.9469942551851273, 0.9389406824111939, 0.9418131691217423, 0.9293023812770843, 0.9289329379796982, 0.9078859329223633, 0.9422546923160553, 0.9472462809085846, 0.9095322954654693, 0.9340816992521286, 0.9614708369970322, 0.9362829023599625, 0.9152713876962661, 0.9483929002285003, 0.9977734452486038, 1.0544635462760925, 0.9290213817358017, 0.9301777762174607, 0.9275600594282151, 0.9332247340679168, 273.9930908203125, 231.79231796264648, 189.59298889160155, 147.39086448669434, 105.1892022705078, 62.986423072814944, 33.335299243927004, 32.11827798843384, 30.9293999004364, 29.757690572738646, 28.58534722328186, 27.41356107711792, 26.241356706619264, 25.069380860328675, 23.89746392250061, 22.725484447479246, 21.555015716552735, 20.59727093219757, 20.069863390922546, 19.549154496192934, 19.028311095237733, 18.507446966171266, 17.986639976501465, 17.465754833221435, 16.944610395431518, 16.423571243286133, 15.902458653450012, 15.38143488407135, 14.860161199569703, 14.338948488235474, 13.817802095413208, 13.29656943321228, 12.7754096698761, 12.254113130569458, 11.732940719127654, 11.211820011138917, 10.69058529138565, 10.169084377288819, 9.647661275863648, 9.12679916858673, 8.60544345855713, 8.084464666843415, 7.563337569236755, 7.042404761314392, 6.5211342692375185, 5.999930319786071, 5.478933863639831, 4.9576491093635555, 4.4366034984588625, 3.9158304786682128, 3.3948850727081297, 2.874178988933563, 2.39222012758255, 2.3027505469322205, 2.30270920753479, 2.302655770778656, 2.302704937458038, 2.302634825706482, 2.3027191185951232, 2.3026928877830506, 2.302821116447449, 2.302686131000519, 2.302655801773071, 2.302790780067444, 2.302773516178131, 2.3027206325531004, 2.302632830142975, 2.3027768969535827, 2.3027260661125184, 2.302708101272583, 2.302832245826721, 2.3027329897880553, 2.3026496171951294, 2.302722482681274, 2.3028117966651918, 2.3027501273155213, 2.30280912399292, 2.302656888961792, 2.3026442694664, 2.302794287204742, 2.302805860042572, 2.3027927255630494, 2.3026517605781556, 2.3027200961112975, 2.302662441730499, 2.3027282691001894, 2.3028229117393493, 2.302763738632202, 2.3026804661750795, 2.3026732134819032, 2.3026761651039123, 2.302692537307739, 2.302689247131348, 2.302702422142029, 2.3026228594779967, 2.3026267218589784, 2.302715277671814, 2.302721426486969, 2.30272490978241, 2.3026891469955446, 2.302656388282776, 2.3026945638656615, 2.3026572847366333, 2.3026508116722106, 2.3027131223678587, 2.302678413391113, 2.3027035212516784, 2.3027202177047728, 2.3027326798439027, 2.302807419300079, 2.3026867151260375, 2.3027616047859194, 2.3028396224975585, 2.30273966550827]
SGD40TestLosses = [2.2543539714813234, 2.0573623263835907, 1.8823221600055695, 1.753808240890503, 1.6674886310100556, 1.5856973624229431, 1.547496645450592, 1.5134061086177826, 1.458909752368927, 1.4544381272792817, 1.4264545905590058, 1.3783738124370575, 1.3668946051597595, 1.3606968379020692, 1.3519601869583129, 1.3186099600791932, 1.3166967380046843, 1.2961990606784821, 1.3208721435070039, 1.269716808795929, 1.3232344496250152, 1.2837545430660249, 1.261585339307785, 1.2745343244075775, 1.2693813574314117, 1.2265679669380187, 1.2694459080696106, 1.2510919868946075, 1.2464069271087646, 1.2635712707042694, 1.2365447902679443, 1.2141309213638305, 1.2949977362155913, 1.2123312413692475, 1.2238654947280885, 1.210182085633278, 1.2102411139011382, 1.191992625594139, 1.203439017534256, 1.204064085483551, 1.1868555623292922, 1.1866106569766999, 1.2722094106674193, 1.1857664042711258, 1.1988480412960052, 1.2122782331705093, 1.203073856830597, 1.1546051287651062, 1.1516731572151184, 1.1633927750587463, 1.2092744278907777, 1.1605670922994613, 1.1466132521629333, 1.1784187209606172, 1.1468238365650176, 1.1242510557174683, 1.125967454314232, 1.1481558722257614, 1.1459156340360641, 1.1288243538141252, 1.174590494632721, 1.175417231321335, 1.137487312555313, 1.128355393409729, 1.145335878133774, 1.1360335218906403, 1.1517261904478073, 1.1379708707332612, 1.1444825249910355, 1.1475453454256057, 1.1272264045476914, 1.1218755382299423, 1.1267617231607436, 1.1423132002353669, 1.1146072113513947, 1.1063438218832016, 1.2315009450912475, 1.1330694270133972, 1.1334130746126174, 1.1584794986248017, 1.1455281084775926, 1.2269318449497222, 1.2189680516719819, 1.2399288642406463, 1.1260484790802001, 1.1617459630966187, 1.1180887186527253, 1.110559492111206, 1.1422677713632583, 1.0975617522001266, 1.1315458631515503, 1.1223753648996353, 1.1179440873861313, 1.102332056760788, 1.1075853061676026, 1.1494349503517152, 1.1335833340883255, 1.1287174063920975, 1.1821664404869079, 1.1169065791368484, 1.1623261702060699, 1.1327160805463792, 1.1491374385356903, 1.1294944429397582, 1.1474177646636963, 1.131231786608696, 1.1279189985990525, 1.1279783350229264, 1.1216840237379073, 1.132113738656044, 1.1420836299657822, 1.12828943669796, 1.1505471986532212, 1.1210223042964935, 1.1264051723480224, 1.0897710919380188, 1.166751955151558, 1.0915345937013625, 1.138764934539795, 1.1020516180992126, 1.101881360411644, 1.1369313609600067, 1.1423012661933898, 1.1051165515184402, 1.1221809405088425, 1.1111016416549682, 1.0865361481904983, 1.0995262944698334, 1.1277442479133606, 1.1080396664142609, 1.1583259838819504, 1.1501055717468263, 1.110228881239891, 1.1380086606740951, 1.1316976231336593, 1.1617476177215575, 1.206689360141754, 1.210085107088089, 1.1663259202241898, 1.1444659024477004, 1.1356274950504304, 1.1451450347900392, 1.1489408266544343, 1.2807803046703339, 1.1601091194152833, 1.1311944752931595, 1.1664137095212936, 1.1891978645324708, 1.162649844288826, 1.1282772821187974, 1.1692757546901702, 1.1522742754220963, 1.114963337779045, 1.1537458825111389, 1.11596639752388, 1.1210962837934495, 1.1227740240097046, 1.1388314878940582, 1.1972347277402877, 1.118499242067337, 1.128339352607727, 1.1082230174541474, 1.1730649667978286, 1.112862650156021, 1.0940430295467376, 1.1001886278390884, 1.1031379568576813, 1.137529103755951, 1.0972109669446946, 1.1128678315877913, 1.1284846431016922, 1.118491015434265, 1.1509823840856552, 1.1658053076267243, 1.1047645968198776, 1.1608255672454835, 1.1285128062963485, 1.1196077519655228, 1.123124104142189, 1.1600053656101226, 1.1208663111925126, 1.1190640062093735, 1.140614926815033, 1.1184977132081986, 1.095853317975998, 1.1008863031864167, 1.1325353163480758, 1.1444921100139618, 1.1351528459787368, 1.108280110359192, 1.1624559772014618, 1.1241112637519837, 1.1235199159383773, 1.1450225073099136, 1.1725427412986755, 1.128828038573265, 1.1226157075166703, 1.115463551878929, 1.1113901156187058, 1.1189436441659928]
plt.plot(SGDTestEpochs, SGDTestLosses, color='b', label="SGD")
plt.plot(SGDTestEpochs, SGD10TestLosses, color='r', label="SGD10")
plt.plot(SGDTestEpochs, SGD20TestLosses, color='g', label="SGD20")
plt.plot(SGDTestEpochs, SGD30TestLosses, color='y', label="SGD30")
plt.plot(SGDTestEpochs, SGD40TestLosses, color='m', label="SGD40")
# for run in range(1, RunNum):
#    plt.plot(GDEpochs[0], GDProductTraces[run], color='b')
#    plt.plot(GDEpochs[0], SGDProductTraces[run], color='r')
plt.yscale('log')
plt.legend()
plt.title("Test Losses of SGD with Regularizations on Cifar10")
plt.xlabel("Epochs")
plt.ylabel("Test Loss")
plt.savefig("Cifar10SGDwRegTestLosses")
plt.close()